/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.filespecs.properties;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jfrog.filespecs.properties.Property;

public class PropertiesParser {
    private static final String PROPS_SEPARATOR = ";";
    private static final String VALUES_SEPARATOR = ",";

    public static List<Property> parsePropertiesStringToList(String props) {
        Map<String, Set<String>> propsMap = PropertiesParser.parsePropertiesStringToMap(props);
        return propsMap.entrySet().stream().map(entry -> new Property((String)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toList());
    }

    private static Map<String, Set<String>> parsePropertiesStringToMap(String props) {
        String[] propsList;
        LinkedHashMap<String, Set<String>> propsMap = new LinkedHashMap<String, Set<String>>();
        if (StringUtils.isEmpty(props)) {
            return propsMap;
        }
        for (String prop : propsList = props.split(PROPS_SEPARATOR)) {
            if (StringUtils.isEmpty(prop)) continue;
            String[] propParts = prop.split("=", 2);
            if (propParts.length != 2) {
                throw new IllegalArgumentException(String.format("Invalid property format: %s - format should be key=val1,val2,...", prop));
            }
            String key = propParts[0];
            String[] valuesParts = propParts[1].split(VALUES_SEPARATOR);
            if (!propsMap.containsKey(key)) {
                propsMap.put(key, new LinkedHashSet());
            }
            StringBuilder valueToAdd = new StringBuilder();
            for (int i = 0; i < valuesParts.length; ++i) {
                valueToAdd.append(valuesParts[i]);
                if (valuesParts[i].endsWith("\\") && i < valuesParts.length - 1) {
                    valueToAdd.setLength(valueToAdd.length() - 1);
                    valueToAdd.append(VALUES_SEPARATOR);
                    continue;
                }
                ((Set)propsMap.get(key)).add(valueToAdd.toString());
                valueToAdd.setLength(0);
            }
        }
        return propsMap;
    }
}

