/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.filespecs.validation;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.filespecs.FileSpec;
import org.jfrog.filespecs.entities.FilesGroup;
import org.jfrog.filespecs.entities.InvalidFileSpecException;

public abstract class SpecsValidator {
    public abstract void validate(FileSpec var1) throws InvalidFileSpecException;

    static void validateQueryInputs(FilesGroup filesGroup) throws InvalidFileSpecException {
        boolean isExclusion;
        boolean isAql = StringUtils.isNotBlank(filesGroup.getAql());
        boolean isPattern = StringUtils.isNotBlank(filesGroup.getPattern());
        boolean bl = isExclusion = !ArrayUtils.isEmpty(filesGroup.getExclusions()) && StringUtils.isNotBlank(filesGroup.getExclusion(0));
        if (isAql && isPattern) {
            throw new InvalidFileSpecException("Spec can't contain both AQL and Pattern keys");
        }
        if (isAql && isExclusion) {
            throw new InvalidFileSpecException("Spec can't contain both AQL and Exclusions keys");
        }
    }
}

