/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.filespecs;

import java.util.ArrayList;
import java.util.List;
import org.jfrog.filespecs.FileSpec;
import org.jfrog.filespecs.FileSpecsValidation;
import org.jfrog.filespecs.aql.AqlConverter;
import org.jfrog.filespecs.distribution.DistributionSpecComponent;
import org.jfrog.filespecs.distribution.PathMapping;
import org.jfrog.filespecs.distribution.PathMappingGenerator;
import org.jfrog.filespecs.entities.FilesGroup;
import org.jfrog.filespecs.entities.InvalidFileSpecException;
import org.jfrog.filespecs.properties.PropertiesParser;
import org.jfrog.filespecs.properties.Property;

public class DistributionHelper {
    public static List<DistributionSpecComponent> toSpecComponents(FileSpec fileSpec) throws InvalidFileSpecException {
        FileSpecsValidation.validateSearchBasedFileSpec(fileSpec);
        ArrayList<DistributionSpecComponent> components = new ArrayList<DistributionSpecComponent>();
        for (FilesGroup file : fileSpec.getFiles()) {
            String aql = AqlConverter.convertFilesGroupToAql(file);
            ArrayList<PathMapping> mappingList = new ArrayList<PathMapping>();
            PathMapping mapping = PathMappingGenerator.createPathMapping(file);
            if (mapping != null) {
                mappingList.add(mapping);
            }
            List<Property> addedProps = PropertiesParser.parsePropertiesStringToList(file.getTargetProps());
            components.add(new DistributionSpecComponent(aql, mappingList, addedProps));
        }
        return components;
    }
}

