/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.DefaultProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jfrog.build.extractor.ProxySelector;
import org.jfrog.build.extractor.maven.resolver.ArtifactoryPluginResolution;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;

@Named
@Component(role=DefaultProjectBuilder.class, hint="default")
public class ArtifactoryProjectBuilder
extends DefaultProjectBuilder {
    @Requirement
    private ResolutionHelper resolutionHelper;

    public List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive, ProjectBuildingRequest request) throws ProjectBuildingException {
        if (Boolean.parseBoolean(System.getProperties().getProperty("buildInfoConfig.artifactoryResolutionEnabled")) || Boolean.parseBoolean(System.getenv("buildInfoConfig.artifactoryResolutionEnabled"))) {
            if (!this.resolutionHelper.isInitialized()) {
                Properties allMavenProps = new Properties();
                allMavenProps.putAll((Map<?, ?>)request.getSystemProperties());
                allMavenProps.putAll((Map<?, ?>)request.getUserProperties());
                this.resolutionHelper.init(allMavenProps);
            }
            List<ArtifactRepository> repositories = this.getRepositories();
            request.setRemoteRepositories(repositories);
            request.setPluginArtifactRepositories(repositories);
        }
        return super.build(pomFiles, recursive, request);
    }

    private List<ArtifactRepository> getRepositories() {
        ArtifactRepository releaseRepository;
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        ProxySelector proxySelector = new ProxySelector(this.resolutionHelper.getHttpProxyHost(), this.resolutionHelper.getHttpProxyPort().intValue(), this.resolutionHelper.getHttpProxyUsername(), this.resolutionHelper.getHttpProxyPassword(), this.resolutionHelper.getHttpsProxyHost(), this.resolutionHelper.getHttpsProxyPort().intValue(), this.resolutionHelper.getHttpsProxyUsername(), this.resolutionHelper.getHttpsProxyPassword(), this.resolutionHelper.getNoProxy());
        ArtifactoryPluginResolution artifactoryResolution = new ArtifactoryPluginResolution(this.resolutionHelper.getRepoReleaseUrl(), this.resolutionHelper.getRepoSnapshotUrl(), this.resolutionHelper.getRepoUsername(), this.resolutionHelper.getRepoPassword(), proxySelector, this.resolutionHelper.getLogger());
        ArtifactRepository snapshotRepository = artifactoryResolution.createSnapshotRepository();
        if (snapshotRepository != null) {
            repositories.add(snapshotRepository);
        }
        if ((releaseRepository = artifactoryResolution.createReleaseRepository()) != null) {
            repositories.add(releaseRepository);
        }
        return repositories;
    }
}

