/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.extractor.ProxySelector;
import org.jfrog.build.extractor.maven.resolver.ArtifactoryResolutionRepositoryBase;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;

public class ArtifactorySonatypeResolution
extends ArtifactoryResolutionRepositoryBase {
    public ArtifactorySonatypeResolution(String repoReleaseUrl, String snapshotRepoUrl, String repoUsername, String repoPassword, ProxySelector proxySelector, Logger logger) {
        super(repoReleaseUrl, snapshotRepoUrl, repoUsername, repoPassword, proxySelector, logger);
    }

    public RemoteRepository createSnapshotRepository() {
        if (super.shouldCreateSnapshotRepository()) {
            return this.createDefaultRepository(this.snapshotRepoUrl, "artifactory-snapshot", false, true);
        }
        return null;
    }

    public RemoteRepository createReleaseRepository() {
        if (super.shouldCreateReleaseRepository()) {
            String repositoryId = this.snapshotPolicyEnabled() ? "artifactory-release-snapshot" : "artifactory-release";
            return this.createDefaultRepository(this.releaseRepoUrl, repositoryId, true, this.snapshotPolicyEnabled());
        }
        return null;
    }

    private RemoteRepository createDefaultRepository(String repoUrl, String repoId, Boolean releasePolicy, boolean snapshotPolicy) {
        RemoteRepository repository = new RemoteRepository();
        this.setPolicy(repository, releasePolicy, snapshotPolicy);
        repository.setUrl(repoUrl);
        repository.setId(repoId);
        this.setAuth(repository);
        this.setProxy(repository);
        return repository;
    }

    private void setPolicy(RemoteRepository snapshotPluginRepository, boolean releasePolicyEnabled, boolean snapshotPolicyEnabled) {
        RepositoryPolicy releasePolicy = new RepositoryPolicy(releasePolicyEnabled, "daily", "warn");
        snapshotPluginRepository.setPolicy(snapshotPolicyEnabled, releasePolicy);
        RepositoryPolicy snapshotPolicy = new RepositoryPolicy(snapshotPolicyEnabled, "daily", "warn");
        snapshotPluginRepository.setPolicy(snapshotPolicyEnabled, snapshotPolicy);
    }

    private void setAuth(RemoteRepository snapshotPluginRepository) {
        if (this.shouldSetAuthentication()) {
            Authentication authentication = new Authentication(this.repoUsername, this.repoPassword);
            snapshotPluginRepository.setAuthentication(authentication);
        }
    }

    private void setProxy(RemoteRepository repository) {
        Proxy proxy = this.createSonatypeProxy(repository.getUrl());
        if (proxy != null) {
            repository.setProxy(proxy);
        }
    }
}

