/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.extractor.ProxySelector;
import org.jfrog.build.extractor.maven.resolver.ArtifactorySonatypeResolution;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.RemoteRepository;

@Named
@Component(role=ArtifactorySonatypeResolversHelper.class)
public class ArtifactorySonatypeResolversHelper {
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private Logger logger;
    private final List<RemoteRepository> resolutionRepositories = new ArrayList<RemoteRepository>();
    private RemoteRepository releaseRepository = null;
    private RemoteRepository snapshotRepository = null;

    public void initResolutionRepositories(RepositorySystemSession session) {
        this.getResolutionRepositories(session);
    }

    public List<RemoteRepository> getResolutionRepositories(RepositorySystemSession session) {
        if (this.resolutionRepositories.isEmpty()) {
            Properties allMavenProps = new Properties();
            allMavenProps.putAll((Map<?, ?>)session.getSystemProperties());
            allMavenProps.putAll((Map<?, ?>)session.getUserProperties());
            this.resolutionHelper.init(allMavenProps);
            ProxySelector proxySelector = new ProxySelector(this.resolutionHelper.getHttpProxyHost(), this.resolutionHelper.getHttpProxyPort().intValue(), this.resolutionHelper.getHttpProxyUsername(), this.resolutionHelper.getHttpProxyPassword(), this.resolutionHelper.getHttpsProxyHost(), this.resolutionHelper.getHttpsProxyPort().intValue(), this.resolutionHelper.getHttpsProxyUsername(), this.resolutionHelper.getHttpsProxyPassword(), this.resolutionHelper.getNoProxy());
            ArtifactorySonatypeResolution artifactoryResolution = new ArtifactorySonatypeResolution(this.resolutionHelper.getRepoReleaseUrl(), this.resolutionHelper.getRepoSnapshotUrl(), this.resolutionHelper.getRepoUsername(), this.resolutionHelper.getRepoPassword(), proxySelector, this.logger);
            this.snapshotRepository = artifactoryResolution.createSnapshotRepository();
            if (this.snapshotRepository != null) {
                this.resolutionRepositories.add(this.snapshotRepository);
            }
            this.releaseRepository = artifactoryResolution.createReleaseRepository();
            if (this.releaseRepository != null) {
                this.resolutionRepositories.add(this.releaseRepository);
            }
        }
        return this.resolutionRepositories;
    }

    public RemoteRepository getSnapshotRepository(RepositorySystemSession session) {
        this.initResolutionRepositories(session);
        if (this.snapshotRepository != null) {
            return this.snapshotRepository;
        }
        return this.releaseRepository;
    }

    public RemoteRepository getReleaseRepository(RepositorySystemSession session) {
        this.initResolutionRepositories(session);
        return this.releaseRepository;
    }
}

