/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.project.DependencyResolutionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.maven.BuildInfoRecorder;

@Component(role=EventSpy.class)
public class DependencyResolutionSpy
extends AbstractEventSpy {
    @Requirement
    private BuildInfoRecorder buildInfoRecorder;

    public void onEvent(Object event) {
        if (event instanceof DependencyResolutionResult) {
            DependencyResolutionResult result = (DependencyResolutionResult)event;
            this.buildInfoRecorder.setDependencyParentsMaps(this.createDependencyParentsMap(result.getDependencyGraph()));
        }
    }

    Map<String, String[][]> createDependencyParentsMap(DependencyNode dependencyNode) {
        HashMap<String, String[][]> dependencyParentsMap = new HashMap<String, String[][]>();
        for (DependencyNode child : dependencyNode.getChildren()) {
            String childGav = this.getGavString(child);
            List<String> parents = Collections.singletonList(this.getGavString(dependencyNode));
            this.addParent(dependencyParentsMap, childGav, parents);
            this.createDependencyParentsMap(dependencyParentsMap, child, parents);
        }
        return dependencyParentsMap;
    }

    private void createDependencyParentsMap(Map<String, String[][]> dependencyParentsMap, DependencyNode dependencyNode, List<String> parent) {
        List<DependencyNode> children = dependencyNode.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        ArrayList<String> childParents = new ArrayList<String>(parent);
        childParents.add(0, this.getGavString(dependencyNode));
        for (DependencyNode child : dependencyNode.getChildren()) {
            String childGav = this.getGavString(child);
            this.addParent(dependencyParentsMap, childGav, childParents);
            this.createDependencyParentsMap(dependencyParentsMap, child, childParents);
        }
    }

    private void addParent(Map<String, String[][]> dependencyParentsMap, String childGav, List<String> parent) {
        String[][] currentParents = dependencyParentsMap.getOrDefault(childGav, new String[0][]);
        currentParents = ArrayUtils.add(currentParents, parent.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        dependencyParentsMap.put(childGav, currentParents);
    }

    private String getGavString(DependencyNode dependencyNode) {
        Artifact artifact = dependencyNode.getArtifact();
        return BuildInfoExtractorUtils.getModuleIdString(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }
}

