/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jfrog.build.extractor.ProxySelector;
import org.jfrog.build.extractor.maven.resolver.ArtifactoryPluginResolution;
import org.jfrog.build.extractor.maven.resolver.ArtifactoryResolution;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;

@Named
@Component(role=ArtifactoryEclipseResolversHelper.class)
public class ArtifactoryEclipseResolversHelper {
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private Logger logger;
    private final List<ArtifactRepository> resolutionPluginRepositories = new ArrayList<ArtifactRepository>();
    private final List<RemoteRepository> resolutionRepositories = new ArrayList<RemoteRepository>();
    private RemoteRepository releaseRepository = null;
    private RemoteRepository snapshotRepository = null;

    void initResolutionRepositories(RepositorySystemSession session) {
        this.getResolutionRepositories(session);
    }

    List<RemoteRepository> getResolutionRepositories(RepositorySystemSession session) {
        if (this.resolutionRepositories.isEmpty()) {
            this.initResolutionHelper(session);
            ArtifactoryResolution artifactoryResolution = this.getArtifactoryResolution();
            this.snapshotRepository = artifactoryResolution.createSnapshotRepository();
            if (this.snapshotRepository != null) {
                this.resolutionRepositories.add(this.snapshotRepository);
            }
            this.releaseRepository = artifactoryResolution.createReleaseRepository();
            if (this.releaseRepository != null) {
                this.resolutionRepositories.add(this.releaseRepository);
            }
        }
        return this.resolutionRepositories;
    }

    private ArtifactoryResolution getArtifactoryResolution() {
        ProxySelector proxySelector = new ProxySelector(this.resolutionHelper.getHttpProxyHost(), this.resolutionHelper.getHttpProxyPort(), this.resolutionHelper.getHttpProxyUsername(), this.resolutionHelper.getHttpProxyPassword(), this.resolutionHelper.getHttpsProxyHost(), this.resolutionHelper.getHttpsProxyPort(), this.resolutionHelper.getHttpsProxyUsername(), this.resolutionHelper.getHttpsProxyPassword(), this.resolutionHelper.getNoProxy());
        return new ArtifactoryResolution(this.resolutionHelper.getRepoReleaseUrl(), this.resolutionHelper.getRepoSnapshotUrl(), this.resolutionHelper.getRepoUsername(), this.resolutionHelper.getRepoPassword(), proxySelector, this.logger).setSnapshotEnabled(this.isSnapshotEnabled()).setSnapshotUpdatePolicy(this.resolutionHelper.getSnapshotUpdatePolicy());
    }

    private void initResolutionHelper(RepositorySystemSession session) {
        if (this.resolutionHelper.isInitialized()) {
            return;
        }
        Properties allMavenProps = new Properties();
        allMavenProps.putAll(session.getSystemProperties());
        allMavenProps.putAll(session.getUserProperties());
        this.resolutionHelper.init(allMavenProps);
    }

    List<ArtifactRepository> getResolutionPluginRepositories(RepositorySystemSession session) {
        if (this.resolutionPluginRepositories.isEmpty()) {
            ArtifactRepository releaseRepository;
            this.initResolutionHelper(session);
            ArtifactoryPluginResolution repositoryBuilder = this.getArtifactoryPluginResolution();
            ArtifactRepository snapshotRepository = repositoryBuilder.createSnapshotRepository();
            if (snapshotRepository != null) {
                this.resolutionPluginRepositories.add(snapshotRepository);
            }
            if ((releaseRepository = repositoryBuilder.createReleaseRepository()) != null) {
                this.resolutionPluginRepositories.add(releaseRepository);
            }
        }
        return this.resolutionPluginRepositories;
    }

    private ArtifactoryPluginResolution getArtifactoryPluginResolution() {
        ProxySelector proxySelector = new ProxySelector(this.resolutionHelper.getHttpProxyHost(), this.resolutionHelper.getHttpProxyPort(), this.resolutionHelper.getHttpProxyUsername(), this.resolutionHelper.getHttpProxyPassword(), this.resolutionHelper.getHttpsProxyHost(), this.resolutionHelper.getHttpsProxyPort(), this.resolutionHelper.getHttpsProxyUsername(), this.resolutionHelper.getHttpsProxyPassword(), this.resolutionHelper.getNoProxy());
        return new ArtifactoryPluginResolution(this.resolutionHelper.getRepoReleaseUrl(), this.resolutionHelper.getRepoSnapshotUrl(), this.resolutionHelper.getRepoUsername(), this.resolutionHelper.getRepoPassword(), proxySelector, this.logger).setSnapshotEnabled(this.isSnapshotEnabled()).setSnapshotUpdatePolicy(this.resolutionHelper.getSnapshotUpdatePolicy());
    }

    RemoteRepository getSnapshotRepository(RepositorySystemSession session) {
        this.initResolutionRepositories(session);
        if (this.snapshotRepository != null) {
            return this.snapshotRepository;
        }
        return this.releaseRepository;
    }

    RemoteRepository getReleaseRepository(RepositorySystemSession session) {
        this.initResolutionRepositories(session);
        return this.releaseRepository;
    }

    private boolean isSnapshotEnabled() {
        return !this.resolutionHelper.isSnapshotDisabled();
    }
}

