/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.npm.extractor;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.producerConsumer.ProducerConsumerItem;
import org.jfrog.build.extractor.npm.types.NpmPackageInfo;
import org.jfrog.build.extractor.producerConsumer.ProducerRunnableBase;

public class NpmExtractorProducer
extends ProducerRunnableBase {
    private DefaultMutableTreeNode dependenciesRootNode;

    NpmExtractorProducer(DefaultMutableTreeNode dependenciesRootNode) {
        this.dependenciesRootNode = dependenciesRootNode;
    }

    public void producerRun() throws InterruptedException {
        try {
            Enumeration<TreeNode> e = this.dependenciesRootNode.breadthFirstEnumeration();
            while (e.hasMoreElements() && !Thread.interrupted()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                NpmPackageInfo npmPackageInfo = (NpmPackageInfo)node.getUserObject();
                if (npmPackageInfo == null) continue;
                if (StringUtils.isBlank((String)npmPackageInfo.getVersion())) {
                    this.log.warn("npm dependencies list contains the package " + npmPackageInfo.getName() + " without version information. The dependency will not be added to build-info");
                    continue;
                }
                this.executor.put((ProducerConsumerItem)npmPackageInfo);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

