/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.npm.extractor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.extractor.builder.ArtifactBuilder;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.npm.extractor.NpmCommand;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;
import org.jfrog.build.util.VersionException;

public class NpmPublish
extends NpmCommand {
    private final ArrayListMultimap<String, String> properties;
    private Artifact deployedArtifact;
    private boolean tarballProvided;
    private final String module;

    public NpmPublish(ArtifactoryManagerBuilder artifactoryManagerBuilder, ArrayListMultimap<String, String> properties, Path path, String deploymentRepository, Log logger, Map<String, String> env, String module) {
        super(artifactoryManagerBuilder, deploymentRepository, logger, path, env);
        this.properties = properties;
        this.module = module;
    }

    public static void main(String[] ignored) {
        try {
            ArtifactoryClientConfiguration clientConfiguration = PackageManagerUtils.createArtifactoryClientConfiguration();
            ArtifactoryManagerBuilder artifactoryManagerBuilder = (ArtifactoryManagerBuilder)new ArtifactoryManagerBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.publisher);
            ArtifactoryClientConfiguration.PackageManagerHandler npmHandler = clientConfiguration.packageManagerHandler;
            NpmPublish npmPublish = new NpmPublish(artifactoryManagerBuilder, (ArrayListMultimap<String, String>)ArrayListMultimap.create((Multimap)clientConfiguration.publisher.getMatrixParams().asMultimap()), Paths.get(npmHandler.getPath() != null ? npmHandler.getPath() : ".", new String[0]), clientConfiguration.publisher.getRepoKey(), clientConfiguration.getLog(), clientConfiguration.getAllProperties(), npmHandler.getModule());
            npmPublish.executeAndSaveBuildInfo(clientConfiguration);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.out);
            System.exit(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BuildInfo execute() {
        try (ArtifactoryManager artifactoryManager = this.artifactoryManagerBuilder.build();){
            this.artifactoryManager = artifactoryManager;
            this.preparePrerequisites();
            if (!this.tarballProvided) {
                this.pack();
            }
            this.deploy();
            if (!this.tarballProvided) {
                this.deleteCreatedTarball();
            }
            BuildInfo buildInfo = this.createBuild();
            return buildInfo;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void setPackageInfo() throws IOException {
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            try (FileInputStream fis = new FileInputStream(this.path.resolve("package.json").toFile());){
                this.npmPackageInfo.readPackageInfo(fis);
            }
        } else {
            this.readPackageInfoFromTarball();
        }
    }

    private void readPackageInfoFromTarball() throws IOException {
        if (!StringUtils.endsWith((CharSequence)this.path.toString(), (CharSequence)".tgz")) {
            throw new IOException("Publish path must be a '.tgz' file or a directory containing package.json");
        }
        try (TarArchiveInputStream inputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.path.toFile()))));){
            TarArchiveEntry entry;
            while ((entry = inputStream.getNextTarEntry()) != null) {
                Path parent = Paths.get(entry.getName(), new String[0]).getParent();
                if (parent == null || !StringUtils.equals((CharSequence)parent.toString(), (CharSequence)"package") || !StringUtils.endsWith((CharSequence)entry.getName(), (CharSequence)"package.json")) continue;
                this.npmPackageInfo.readPackageInfo((InputStream)inputStream);
                this.tarballProvided = true;
                return;
            }
        }
        throw new IOException("Couldn't find package.json in " + this.path.toString());
    }

    private void pack() throws IOException {
        String packageFileName = this.npmDriver.pack(this.workingDir.toFile(), new ArrayList<String>(), this.logger);
        this.path = this.path.resolve(packageFileName);
    }

    private void deploy() throws IOException {
        this.readPackageInfoFromTarball();
        this.doDeploy();
    }

    private void preparePrerequisites() throws InterruptedException, VersionException, IOException {
        this.validateArtifactoryVersion();
        this.validateNpmVersion();
        NpmPublish.validateRepoExists((ArtifactoryManager)this.artifactoryManager, (String)this.repo, (String)"Target repo must be specified");
        this.setPackageInfo();
    }

    private void deleteCreatedTarball() throws IOException {
        Files.deleteIfExists(this.path);
    }

    private BuildInfo createBuild() {
        String moduleID = StringUtils.isNotBlank((CharSequence)this.module) ? this.module : this.npmPackageInfo.toString();
        List<Artifact> artifactList = Collections.singletonList(this.deployedArtifact);
        Module module = new ModuleBuilder().type(ModuleType.NPM).id(moduleID).repository(this.repo).artifacts(artifactList).build();
        List<Module> modules = Collections.singletonList(module);
        BuildInfo buildInfo = new BuildInfo();
        buildInfo.setModules(modules);
        return buildInfo;
    }

    private void doDeploy() throws IOException {
        DeployDetails deployDetails = new DeployDetails.Builder().file(this.path.toFile()).targetRepository(this.repo).addProperties(this.properties).artifactPath(this.npmPackageInfo.getDeployPath()).packageType(DeployDetails.PackageType.NPM).build();
        ArtifactoryUploadResponse response = this.artifactoryManager.upload(deployDetails);
        this.deployedArtifact = new ArtifactBuilder(this.npmPackageInfo.getModuleId()).md5(response.getChecksums().getMd5()).sha1(response.getChecksums().getSha1()).remotePath(StringUtils.substringBeforeLast((String)this.npmPackageInfo.getDeployPath(), (String)"/")).build();
    }
}

