/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.pip.extractor;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.pip.extractor.DependenciesCache;
import org.jfrog.build.extractor.pip.extractor.PipLogParser;

public class PipBuildInfoExtractor {
    private static final String PIP_AQL_FORMAT = "items.find({\"repo\":\"%s\",\"$or\":[%s]}).include(\"name\",\"repo\",\"path\",\"actual_sha1\",\"actual_md5\")";
    private static final String PIP_AQL_FILE_PART = "{\"name\":\"%s\"},";
    private static final int PIP_AQL_BULK_SIZE = 3;

    Build extract(ArtifactoryManager artifactoryManager, String repository, String installationLog, Path executionPath, String module, Log logger) throws IOException {
        Map<String, String> downloadedDependencies = PipLogParser.parse(installationLog, logger);
        Map<String, Dependency> dependenciesMap = this.buildDependenciesMap(downloadedDependencies, artifactoryManager, repository, executionPath, logger);
        ArrayList<Dependency> dependenciesList = new ArrayList<Dependency>(dependenciesMap.values());
        return this.createBuild(dependenciesList, module);
    }

    Map<String, Dependency> buildDependenciesMap(Map<String, String> downloadedDependencies, ArtifactoryManager artifactoryManager, String repository, Path executionPath, Log logger) throws IOException {
        HashMap<String, Dependency> dependenciesMap = new HashMap<String, Dependency>();
        DependenciesCache dependenciesCache = DependenciesCache.getProjectDependenciesCache(executionPath, logger);
        HashMap<String, String> getFromArtifactoryMap = new HashMap<String, String>();
        for (String pkgName : downloadedDependencies.keySet()) {
            String fileName = downloadedDependencies.get(pkgName);
            if (StringUtils.isNotBlank((String)fileName)) {
                getFromArtifactoryMap.put(fileName, pkgName);
                continue;
            }
            if (dependenciesCache == null || dependenciesCache.getDependency(pkgName) == null) continue;
            dependenciesMap.put(pkgName, dependenciesCache.getDependency(pkgName));
        }
        dependenciesMap.putAll(this.getDependenciesFromArtifactory(getFromArtifactoryMap, repository, artifactoryManager, logger));
        Set<String> missingDeps = downloadedDependencies.keySet().stream().filter(x -> !dependenciesMap.containsKey(x)).collect(Collectors.toSet());
        this.promptMissingDeps(missingDeps, logger);
        DependenciesCache.updateDependenciesCache(dependenciesMap, executionPath);
        return dependenciesMap;
    }

    private Map<String, Dependency> getDependenciesFromArtifactory(Map<String, String> fileToPackageMap, String repository, ArtifactoryManager artifactoryManager, Log logger) throws IOException {
        if (fileToPackageMap.isEmpty()) {
            return Collections.emptyMap();
        }
        AqlSearchResult searchResult = this.runAqlQueries(PipBuildInfoExtractor.createAqlQueries(fileToPackageMap, repository, 3), artifactoryManager);
        return this.createDependenciesFromAqlResult(searchResult, fileToPackageMap, logger);
    }

    static List<String> createAqlQueries(Map<String, String> fileToPackageMap, String repository, int bulkSize) {
        ArrayList<String> aqlQueries = new ArrayList<String>();
        StringBuilder filesQueryPartBuilder = new StringBuilder();
        int filesCounter = 0;
        for (String file : fileToPackageMap.keySet()) {
            filesQueryPartBuilder.append(String.format(PIP_AQL_FILE_PART, file));
            if (++filesCounter != bulkSize) continue;
            aqlQueries.add(PipBuildInfoExtractor.getPipDependenciesAql(filesQueryPartBuilder, repository));
            filesCounter = 0;
            filesQueryPartBuilder.setLength(0);
        }
        if (filesQueryPartBuilder.length() > 0) {
            aqlQueries.add(PipBuildInfoExtractor.getPipDependenciesAql(filesQueryPartBuilder, repository));
        }
        return aqlQueries;
    }

    static String getPipDependenciesAql(StringBuilder filesQueryPartBuilder, String repository) {
        filesQueryPartBuilder.setLength(filesQueryPartBuilder.length() - 1);
        return String.format(PIP_AQL_FORMAT, repository, filesQueryPartBuilder.toString());
    }

    private AqlSearchResult runAqlQueries(List<String> aqlQueries, ArtifactoryManager artifactoryManager) throws IOException {
        AqlSearchResult aggregatedResults = new AqlSearchResult();
        for (String aql : aqlQueries) {
            try {
                AqlSearchResult searchResult = artifactoryManager.searchArtifactsByAql(aql);
                if (searchResult.getResults().isEmpty()) continue;
                aggregatedResults.getResults().addAll(searchResult.getResults());
            }
            catch (IOException e) {
                throw new IOException("Failed fetching dependencies checksums from Artifactory ", e);
            }
        }
        return aggregatedResults;
    }

    private Map<String, Dependency> createDependenciesFromAqlResult(AqlSearchResult searchResult, Map<String, String> fileToPackage, Log logger) {
        if (searchResult.getResults().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Dependency> dependenciesMap = new HashMap<String, Dependency>();
        for (AqlSearchResult.SearchEntry searchEntry : searchResult.getResults()) {
            if (!this.isResultComplete(searchEntry) || dependenciesMap.containsKey(fileToPackage.get(searchEntry.getName())) || !fileToPackage.containsKey(searchEntry.getName())) continue;
            Dependency curDep = new DependencyBuilder().id(searchEntry.getName()).md5(searchEntry.getActualMd5()).sha1(searchEntry.getActualSha1()).build();
            dependenciesMap.put(fileToPackage.get(searchEntry.getName()), curDep);
        }
        Set<String> missingFiles = fileToPackage.keySet().stream().filter(x -> !dependenciesMap.containsKey(fileToPackage.get(x))).collect(Collectors.toSet());
        this.promptMissingChecksumFromArtifactory(missingFiles, logger);
        return dependenciesMap;
    }

    private boolean isResultComplete(AqlSearchResult.SearchEntry searchEntry) {
        return StringUtils.isNotBlank((String)searchEntry.getName()) && StringUtils.isNotBlank((String)searchEntry.getActualMd5()) && StringUtils.isNotBlank((String)searchEntry.getActualSha1());
    }

    private void promptMissingDeps(Set<String> missingDeps, Log logger) {
        if (!missingDeps.isEmpty()) {
            logger.info(Arrays.toString(missingDeps.toArray()));
            logger.info("The pypi packages above could not be found in Artifactory or were not downloaded in this execution, therefore they are not included in the build-info.\nReinstalling in clean environment or using '--no-cache-dir' and '--force-reinstall' flags (in one execution only), will force downloading and populating Artifactory with these packages, and therefore resolve the issue.");
        }
    }

    private void promptMissingChecksumFromArtifactory(Set<String> notFoundFiles, Log logger) {
        if (notFoundFiles.size() < 1) {
            return;
        }
        logger.debug(Arrays.toString(notFoundFiles.toArray()));
        logger.debug("Failed fetching checksums from Artifactory for the above files.");
    }

    private Build createBuild(List<Dependency> dependenciesList, String moduleName) {
        Module module = new ModuleBuilder().type(ModuleType.PYPI).id(moduleName).dependencies(dependenciesList).build();
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(module);
        Build build = new Build();
        build.setModules(modules);
        return build;
    }
}

