/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.pip.extractor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ci.Dependency;

public class DependenciesCache {
    private static final int CACHE_VERSION = 1;
    private static final ObjectMapper objectMapper = BuildInfoExtractorUtils.createMapper();
    @JsonProperty(value="version")
    private int version = 1;
    @JsonProperty(value="dependencies")
    private Map<String, Dependency> dependencies = new HashMap<String, Dependency>();

    DependenciesCache() {
    }

    static DependenciesCache getProjectDependenciesCache(Path executionPath, Log logger) throws IOException {
        Path cachePath = DependenciesCache.getCacheFilePath(executionPath);
        File cacheFile = cachePath.toFile();
        if (!cacheFile.exists()) {
            Files.createDirectories(cacheFile.toPath().getParent(), new FileAttribute[0]);
            return null;
        }
        DependenciesCache cache = new DependenciesCache();
        cache.read(cacheFile, logger);
        return cache;
    }

    static void updateDependenciesCache(Map<String, Dependency> updateMap, Path executionPath) throws IOException {
        DependenciesCache cache = new DependenciesCache();
        cache.dependencies = updateMap;
        Path cachePath = DependenciesCache.getCacheFilePath(executionPath);
        File cacheFile = cachePath.toFile();
        cache.write(cacheFile);
    }

    static Path getCacheFilePath(Path workDir) {
        Path absoluteWorkDir = workDir.toAbsolutePath().normalize();
        return Paths.get(absoluteWorkDir.toString(), ".jfrog", "projects", "deps.cache.json");
    }

    void read(File file, Log logger) throws IOException {
        try {
            DependenciesCache dependenciesCache = (DependenciesCache)objectMapper.readValue(file, DependenciesCache.class);
            if (dependenciesCache.getVersion() != 1) {
                logger.warn("Incorrect cache version " + dependenciesCache.getVersion() + ". Zapping the old cache.");
                return;
            }
            this.dependencies = dependenciesCache.dependencies;
        }
        catch (JsonParseException | JsonMappingException e) {
            logger.error("Failed reading cache file, zapping the old cache.");
        }
    }

    void write(File file) throws IOException {
        objectMapper.writeValue(file, (Object)this);
    }

    Dependency getDependency(String dependencyName) {
        return this.dependencies.get(dependencyName);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Map<String, Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Map<String, Dependency> dependencies) {
        this.dependencies = dependencies;
    }
}

