/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.release.Distribution;
import org.jfrog.build.api.release.Promotion;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryHttpClient;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.ItemLastModified;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.Version;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.DeploymentUrlUtils;
import org.jfrog.build.extractor.clientConfiguration.util.JsonSerializer;
import org.jfrog.build.extractor.usageReport.UsageReporter;
import org.jfrog.build.util.VersionCompatibilityType;
import org.jfrog.build.util.VersionException;

public class ArtifactoryBuildInfoClient
extends ArtifactoryBaseClient
implements AutoCloseable {
    public static final String BUILD_BROWSE_URL = "/webapp/builds";
    public static final String BUILD_BROWSE_PLATFORM_URL = "/ui/builds";
    public static final String APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON = "application/vnd.org.jfrog.artifactory+json";
    public static final String APPLICATION_JSON = "application/json";
    public static final String ITEM_LAST_MODIFIED = "/api/storage/";
    private static final String LOCAL_REPOS_REST_URL = "/api/repositories?type=local";
    private static final String REMOTE_REPOS_REST_URL = "/api/repositories?type=remote";
    private static final String VIRTUAL_REPOS_REST_URL = "/api/repositories?type=virtual";
    private static final String PUSH_TO_BINTRAY_REST_URL = "/api/build/pushToBintray/";
    private static final String BUILD_REST_URL = "/api/build";
    private static final String BUILD_RETENTION_REST_URL = "/api/build/retention/";
    private static final String BUILD_RETENTION_REST_ASYNC_PARAM = "?async=";
    private static final String BUILD_PROJECT_PARAM = "?project=";
    private static final String USAGE_API = "/api/system/usage";
    private static final ArtifactoryVersion USAGE_ARTIFACTORY_MIN_VERSION = new ArtifactoryVersion("6.9.0");
    private int minChecksumDeploySizeKb = 10;

    public ArtifactoryBuildInfoClient(String artifactoryUrl, Log log) {
        this(artifactoryUrl, "", "", "", log);
    }

    public ArtifactoryBuildInfoClient(String artifactoryUrl, String username, String password, String accessToken, Log log) {
        super(artifactoryUrl, username, password, accessToken, log);
    }

    public ArtifactoryBuildInfoClient(String artifactoryUrl, String username, String password, Log log) {
        this(artifactoryUrl, username, password, "", log);
    }

    public static String getProjectQueryParam(String project, String prefix) {
        if (StringUtils.isNotEmpty((String)project)) {
            return prefix + ArtifactoryHttpClient.encodeUrl((String)project);
        }
        return "";
    }

    public static String getProjectQueryParam(String project) {
        return ArtifactoryBuildInfoClient.getProjectQueryParam(project, BUILD_PROJECT_PARAM);
    }

    public static String createBuildInfoUrl(String platformUrl, String buildName, String buildNumber, String timeStamp, String project) {
        return String.format("%s/%s/%s/%s/%s", platformUrl + BUILD_BROWSE_PLATFORM_URL, ArtifactoryHttpClient.encodeUrl((String)buildName), ArtifactoryHttpClient.encodeUrl((String)buildNumber), timeStamp, "published" + ArtifactoryBuildInfoClient.getProjectQueryParam(project));
    }

    public static String createBuildInfoUrl(String artifactoryUrl, String buildName, String buildNumber) {
        return String.format("%s/%s/%s", artifactoryUrl + BUILD_BROWSE_URL, ArtifactoryHttpClient.encodeUrl((String)buildName), ArtifactoryHttpClient.encodeUrl((String)buildNumber));
    }

    public List<String> getLocalRepositoriesKeys() throws IOException {
        return this.getRepositoriesList(LOCAL_REPOS_REST_URL);
    }

    public void setMinChecksumDeploySizeKb(int minChecksumDeploySizeKb) {
        this.minChecksumDeploySizeKb = minChecksumDeploySizeKb;
    }

    public List<String> getLocalAndCacheRepositoriesKeys() throws IOException {
        List<String> localRepositoriesKeys = this.getLocalRepositoriesKeys();
        List<String> remoteRepositories = this.getRemoteRepositoriesKeys();
        ArrayList cacheRepositories = CommonUtils.transformList(remoteRepositories, repoKey -> repoKey + "-cache");
        return CommonUtils.concatLists(localRepositoriesKeys, (List)cacheRepositories);
    }

    public List<String> getRemoteRepositoriesKeys() throws IOException {
        return this.getRepositoriesList(REMOTE_REPOS_REST_URL);
    }

    public List<String> getVirtualRepositoryKeys() throws IOException {
        return this.getRepositoriesList(VIRTUAL_REPOS_REST_URL);
    }

    private List<String> getRepositoriesList(String restUrl) throws IOException {
        ArrayList<String> repositories = new ArrayList<String>();
        String reposUrl = this.artifactoryUrl + restUrl;
        this.log.debug("Requesting repositories list from: " + reposUrl);
        try (PreemptiveHttpClient client = this.httpClient.getHttpClient();
             CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(reposUrl));){
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() != 200) {
                String message = this.httpClient.getMessageFromEntity(entity);
                EntityUtils.consumeQuietly((HttpEntity)entity);
                throw new IOException("Failed to obtain list of repositories. Status code: " + statusLine.getStatusCode() + message);
            }
            if (entity == null) {
                ArrayList<String> message = repositories;
                return message;
            }
            try (InputStream content = entity.getContent();){
                JsonParser parser = this.httpClient.createJsonParser(content);
                JsonNode result = (JsonNode)parser.readValueAsTree();
                this.log.debug("Repositories result = " + result);
                for (JsonNode jsonNode : result) {
                    String repositoryKey = jsonNode.get("key").asText();
                    repositories.add(repositoryKey);
                }
            }
        }
        return repositories;
    }

    public void sendBuildInfo(String buildInfoJson, String project) throws IOException {
        String url = String.format("%s%s%s", this.artifactoryUrl, BUILD_REST_URL, ArtifactoryBuildInfoClient.getProjectQueryParam(project));
        HttpPut httpPut = new HttpPut(url);
        try {
            this.log.info("Deploying build descriptor to: " + httpPut.getURI().toString());
            this.sendHttpEntityRequest((HttpEntityEnclosingRequestBase)httpPut, buildInfoJson, APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON);
        }
        catch (IOException e) {
            throw new IOException("Failed to send build descriptor. " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Build getBuildInfo(String buildName, String buildNumber, String project) throws IOException {
        if ((buildNumber = this.getLatestBuildNumberFromArtifactory(buildName, buildNumber, project)) == null) {
            return null;
        }
        String url = String.format("%s%s/%s/%s%s", this.artifactoryUrl, BUILD_REST_URL, ArtifactoryHttpClient.encodeUrl((String)buildName), ArtifactoryHttpClient.encodeUrl((String)buildNumber), ArtifactoryBuildInfoClient.getProjectQueryParam(project));
        HttpGet httpGet = new HttpGet(url);
        try (CloseableHttpResponse httpResponse = this.sendHttpRequest((HttpUriRequest)httpGet, 200);){
            String buildInfoJson = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            Build build = this.getBuildFromJson(buildInfoJson);
            return build;
        }
        catch (IOException e) {
            throw new IOException("Failed to get build info. " + e.getMessage(), e);
        }
    }

    private String getLatestBuildNumberFromArtifactory(String buildName, String buildNumber, String project) throws IOException {
        ArtifactoryDependenciesClient dependenciesClient = new ArtifactoryDependenciesClient(this.artifactoryUrl, this.httpClient, this.log);
        return dependenciesClient.getLatestBuildNumberFromArtifactory(buildName, buildNumber, project);
    }

    public void sendBuildRetetion(BuildRetention buildRetention, String buildName, String project, boolean async) throws IOException {
        String buildRetentionJson = this.toJsonString(buildRetention);
        String url = this.artifactoryUrl + BUILD_RETENTION_REST_URL + buildName + BUILD_RETENTION_REST_ASYNC_PARAM + async + ArtifactoryBuildInfoClient.getProjectQueryParam(project, "&project=");
        HttpPost httpPost = new HttpPost(url);
        try {
            this.log.info(this.createBuildRetentionLogMsg(buildRetention, async));
            this.log.debug(buildRetentionJson);
            this.sendHttpEntityRequest((HttpEntityEnclosingRequestBase)httpPost, buildRetentionJson, APPLICATION_JSON);
        }
        catch (IOException e) {
            this.log.error("Failed to execute build retention.", (Throwable)e);
            throw new IOException("Failed to execute build retention: " + e.getMessage(), e);
        }
    }

    private String createBuildRetentionLogMsg(BuildRetention buildRetention, boolean async) {
        StringBuilder strBuilder = new StringBuilder().append("Sending");
        if (async) {
            strBuilder.append(" async");
        }
        strBuilder.append(" request for build retention");
        if (buildRetention.isDeleteBuildArtifacts()) {
            strBuilder.append(", deleting build artifacts");
        }
        if (buildRetention.getCount() != -1) {
            strBuilder.append(", max number of builds to store: ").append(buildRetention.getCount());
        }
        if (buildRetention.getMinimumBuildDate() != null) {
            strBuilder.append(", min build date: ").append(buildRetention.getMinimumBuildDate());
        }
        if (!buildRetention.getBuildNumbersNotToBeDiscarded().isEmpty()) {
            strBuilder.append(", build numbers not to be discarded: ").append(buildRetention.getBuildNumbersNotToBeDiscarded());
        }
        strBuilder.append(".");
        return strBuilder.toString();
    }

    public void sendModuleInfo(Build build) throws IOException {
        this.log.debug("Sending build info modules: " + build);
        try {
            String url = this.artifactoryUrl + BUILD_REST_URL + "/append/" + ArtifactoryHttpClient.encodeUrl((String)build.getName()) + "/" + ArtifactoryHttpClient.encodeUrl((String)build.getNumber());
            HttpPost httpPost = new HttpPost(url);
            String modulesAsJsonString = this.toJsonString(build.getModules());
            this.log.info("Deploying build descriptor to: " + httpPost.getURI().toString());
            this.sendHttpEntityRequest((HttpEntityEnclosingRequestBase)httpPost, modulesAsJsonString, APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON);
        }
        catch (Exception e) {
            this.log.error("Could not build the build-info modules object.", (Throwable)e);
            throw new IOException("Could not publish build-info modules: " + e.getMessage(), e);
        }
    }

    private void sendHttpEntityRequest(HttpEntityEnclosingRequestBase request, String content, String contentType) throws IOException {
        StringEntity stringEntity = new StringEntity(content, "UTF-8");
        stringEntity.setContentType(contentType);
        request.setEntity((HttpEntity)stringEntity);
        try (CloseableHttpResponse response = this.sendHttpRequest((HttpUriRequest)request, 201, 200, 204);){
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    private CloseableHttpResponse sendHttpRequest(HttpUriRequest request, int ... httpStatuses) throws IOException {
        CloseableHttpResponse httpResponse = this.httpClient.getHttpClient().execute(request);
        StatusLine statusLine = httpResponse.getStatusLine();
        for (int status : httpStatuses) {
            if (statusLine.getStatusCode() != status) continue;
            return httpResponse;
        }
        HttpEntity responseEntity = null;
        try {
            responseEntity = httpResponse.getEntity();
            String message = this.httpClient.getMessageFromEntity(responseEntity);
            throw new IOException(statusLine.getStatusCode() + ": " + message);
        }
        catch (Throwable throwable) {
            EntityUtils.consumeQuietly((HttpEntity)responseEntity);
            httpResponse.close();
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public ItemLastModified getItemLastModified(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ArtifactoryUploadResponse deployArtifact(DeployDetails details) throws IOException {
        return this.deployArtifact(details, null);
    }

    public ArtifactoryUploadResponse deployArtifact(DeployDetails details, String logPrefix) throws IOException {
        String deploymentPath = this.buildDeploymentPath(details);
        logPrefix = logPrefix == null ? "" : logPrefix + " ";
        this.log.info(logPrefix + "Deploying artifact: " + deploymentPath);
        return this.doDeployArtifact(details, deploymentPath);
    }

    private String buildDeploymentPath(DeployDetails details) throws IOException {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(ArtifactoryHttpClient.encodeUrl((String)this.artifactoryUrl));
        pathComponents.add(DeploymentUrlUtils.encodePath(details.getTargetRepository()));
        pathComponents.add(DeploymentUrlUtils.encodePath(details.getArtifactPath()));
        return StringUtils.join(pathComponents, (String)"/");
    }

    private ArtifactoryUploadResponse doDeployArtifact(DeployDetails details, String deploymentPath) throws IOException {
        ArtifactoryUploadResponse response = this.uploadFile(details, deploymentPath);
        if (!this.getArtifactoryVersion().isAtLeast((Version)new ArtifactoryVersion("2.3.2"))) {
            this.uploadChecksums(details, deploymentPath);
        }
        return response;
    }

    public ArtifactoryVersion verifyCompatibleArtifactoryVersion() throws VersionException {
        ArtifactoryVersion version;
        try {
            version = this.httpClient.getVersion();
        }
        catch (IOException e) {
            throw new VersionException("Error occurred while requesting version information: " + e, (Throwable)e, VersionCompatibilityType.NOT_FOUND);
        }
        if (version.isNotFound()) {
            throw new VersionException("There is either an incompatible or no instance of Artifactory at the provided URL.", VersionCompatibilityType.NOT_FOUND);
        }
        boolean isCompatibleArtifactory = version.isAtLeast((Version)ArtifactoryHttpClient.MINIMAL_ARTIFACTORY_VERSION);
        if (!isCompatibleArtifactory) {
            throw new VersionException("This plugin is compatible with version " + ArtifactoryHttpClient.MINIMAL_ARTIFACTORY_VERSION + " of Artifactory and above. Please upgrade your Artifactory server!", VersionCompatibilityType.INCOMPATIBLE);
        }
        return version;
    }

    public CloseableHttpResponse stageBuild(String buildName, String buildNumber, Promotion promotion) throws IOException {
        if (StringUtils.isBlank((String)buildName)) {
            throw new IllegalArgumentException("Build name is required for promotion.");
        }
        if (StringUtils.isBlank((String)buildNumber)) {
            throw new IllegalArgumentException("Build number is required for promotion.");
        }
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append(BUILD_REST_URL).append("/promote/").append(ArtifactoryHttpClient.encodeUrl((String)buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl((String)buildNumber));
        String promotionJson = this.toJsonString(promotion);
        HttpPost httpPost = new HttpPost(urlBuilder.toString());
        StringEntity stringEntity = new StringEntity(promotionJson);
        stringEntity.setContentType("application/vnd.org.jfrog.artifactory.build.PromotionRequest+json");
        httpPost.setEntity((HttpEntity)stringEntity);
        this.log.info("Promoting build " + buildName + ", #" + buildNumber);
        return this.httpClient.getHttpClient().execute((HttpUriRequest)httpPost);
    }

    public CloseableHttpResponse distributeBuild(String buildName, String buildNumber, Distribution promotion) throws IOException {
        if (StringUtils.isBlank((String)buildName)) {
            throw new IllegalArgumentException("Build name is required for distribution.");
        }
        if (StringUtils.isBlank((String)buildNumber)) {
            throw new IllegalArgumentException("Build number is required for distribution.");
        }
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append(BUILD_REST_URL).append("/distribute/").append(ArtifactoryHttpClient.encodeUrl((String)buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl((String)buildNumber));
        String distributionJson = this.toJsonString(promotion);
        HttpPost httpPost = new HttpPost(urlBuilder.toString());
        StringEntity stringEntity = new StringEntity(distributionJson);
        stringEntity.setContentType(APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)stringEntity);
        this.log.info("Distributing build " + buildName + ", #" + buildNumber);
        return this.httpClient.getHttpClient().execute((HttpUriRequest)httpPost);
    }

    /*
     * Exception decompiling
     */
    public Map<String, List<Map>> getUserPluginInfo() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CloseableHttpResponse executeUserPlugin(String executionName, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/execute/").append(executionName).append("?");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpPost postRequest = new HttpPost(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute((HttpUriRequest)postRequest);
    }

    /*
     * Exception decompiling
     */
    public Map getStagingStrategy(String strategyName, String buildName, Map<String, String> requestParams) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CloseableHttpResponse executePromotionUserPlugin(String promotionName, String buildName, String buildNumber, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/build/promote/").append(promotionName).append("/").append(ArtifactoryHttpClient.encodeUrl((String)buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl((String)buildNumber)).append("?");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpPost postRequest = new HttpPost(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute((HttpUriRequest)postRequest);
    }

    public CloseableHttpResponse executeUpdateFileProperty(String itemPath, String properties) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append(ITEM_LAST_MODIFIED).append(ArtifactoryHttpClient.encodeUrl((String)itemPath)).append("?").append("properties=").append(ArtifactoryHttpClient.encodeUrl((String)properties));
        HttpPut postRequest = new HttpPut(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute((HttpUriRequest)postRequest);
    }

    private void appendParamsToUrl(Map<String, String> requestParams, StringBuilder urlBuilder) throws UnsupportedEncodingException {
        if (requestParams != null && !requestParams.isEmpty()) {
            urlBuilder.append("params=");
            Iterator<Map.Entry<String, String>> paramEntryIterator = requestParams.entrySet().iterator();
            String encodedPipe = ArtifactoryHttpClient.encodeUrl((String)"|");
            while (paramEntryIterator.hasNext()) {
                Map.Entry<String, String> paramEntry = paramEntryIterator.next();
                urlBuilder.append(ArtifactoryHttpClient.encodeUrl((String)paramEntry.getKey()));
                String paramValue = paramEntry.getValue();
                if (StringUtils.isNotBlank((String)paramValue)) {
                    urlBuilder.append("=").append(ArtifactoryHttpClient.encodeUrl((String)paramValue));
                }
                if (!paramEntryIterator.hasNext()) continue;
                urlBuilder.append(encodedPipe);
            }
        }
    }

    public String buildInfoToJsonString(Build buildInfo) throws Exception {
        ArtifactoryVersion version = this.verifyCompatibleArtifactoryVersion();
        if (!version.isAtLeast((Version)ArtifactoryHttpClient.UNKNOWN_PROPERTIES_TOLERANT_ARTIFACTORY_VERSION)) {
            buildInfo.setBuildAgent(null);
            buildInfo.setParentName(null);
            buildInfo.setParentNumber(null);
        }
        if (!version.isAtLeast((Version)ArtifactoryHttpClient.NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION)) {
            String buildNumber = buildInfo.getNumber();
            this.verifyNonNumericBuildNumber(buildNumber);
            String parentBuildNumber = buildInfo.getParentNumber();
            this.verifyNonNumericBuildNumber(parentBuildNumber);
        }
        return this.toJsonString(buildInfo);
    }

    String toJsonString(Object object) throws IOException {
        JsonFactory jsonFactory = this.httpClient.createJsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator((Writer)writer);
        jsonGenerator.useDefaultPrettyPrinter();
        jsonGenerator.writeObject(object);
        String result = writer.getBuffer().toString();
        return result;
    }

    private Build getBuildFromJson(String buildInfoJson) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualObj = mapper.readTree(buildInfoJson);
        return (Build)mapper.readValue(actualObj.get("buildInfo").toString(), Build.class);
    }

    private void verifyNonNumericBuildNumber(String buildNumber) {
        if (buildNumber != null) {
            try {
                Long.parseLong(buildNumber);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot handle build/parent build number: " + buildNumber + ". Non-numeric build numbers are supported by Artifactory version " + ArtifactoryHttpClient.NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION + " and above. Please upgrade your Artifactory or use numeric build numbers.");
            }
        }
    }

    private ArtifactoryUploadResponse uploadFile(DeployDetails details, String uploadUrl) throws IOException {
        FileEntity fileEntity;
        int statusCode;
        ArtifactoryUploadResponse response = this.tryChecksumDeploy(details, uploadUrl);
        if (response != null) {
            return response;
        }
        HttpPut httpPut = this.createHttpPutMethod(details, uploadUrl);
        httpPut.addHeader("Expect", "100-continue");
        if (details.isExplode()) {
            httpPut.addHeader("X-Explode-Archive", "true");
        }
        if ((statusCode = (response = this.httpClient.upload(httpPut, (HttpEntity)(fileEntity = new FileEntity(details.getFile(), "binary/octet-stream")))).getStatusLine().getStatusCode()) != 201 && statusCode != 200) {
            throw new IOException("Failed to deploy file. Status code: " + statusCode + this.getMessage(response));
        }
        return response;
    }

    private ArtifactoryUploadResponse tryChecksumDeploy(DeployDetails details, String uploadUrl) throws UnsupportedEncodingException {
        long fileLength = details.getFile().length();
        if (fileLength < (long)(this.minChecksumDeploySizeKb * 1024)) {
            this.log.debug("Skipping checksum deploy of file size " + fileLength + " bytes, falling back to regular deployment.");
            return null;
        }
        if (details.isExplode()) {
            this.log.debug("Skipping checksum deploy due to explode file request.");
            return null;
        }
        if (!this.getArtifactoryVersion().isAtLeast((Version)new ArtifactoryVersion("2.5.1"))) {
            return null;
        }
        HttpPut httpPut = this.createHttpPutMethod(details, uploadUrl);
        httpPut.addHeader("X-Checksum-Deploy", "true");
        String fileAbsolutePath = details.getFile().getAbsolutePath();
        try {
            ArtifactoryUploadResponse response = this.httpClient.execute(httpPut);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 201 || statusCode == 200) {
                this.log.debug("Successfully performed checksum deploy of file " + fileAbsolutePath + " : " + details.getSha1());
                return response;
            }
            this.log.debug("Failed checksum deploy of checksum '" + details.getSha1() + "' with statusCode: " + statusCode);
        }
        catch (IOException e) {
            this.log.debug("Failed artifact checksum deploy of file " + fileAbsolutePath + " : " + details.getSha1());
        }
        return null;
    }

    private HttpPut createHttpPutMethod(DeployDetails details, String uploadUrl) throws UnsupportedEncodingException {
        StringBuilder deploymentPathBuilder = new StringBuilder().append(uploadUrl);
        deploymentPathBuilder.append(DeploymentUrlUtils.buildMatrixParamsString(details.getProperties(), true));
        HttpPut httpPut = new HttpPut(deploymentPathBuilder.toString());
        httpPut.addHeader("X-Checksum-Sha1", details.getSha1());
        httpPut.addHeader("X-Checksum-Md5", details.getMd5());
        this.log.debug("Full Artifact Http path: " + httpPut + "\n@Http Headers: " + Arrays.toString(httpPut.getAllHeaders()));
        return httpPut;
    }

    public void uploadChecksums(DeployDetails details, String uploadUrl) throws IOException {
        String md5;
        Map<String, String> checksums = this.getChecksumMap(details);
        String fileAbsolutePath = details.getFile().getAbsolutePath();
        String sha1 = checksums.get("SHA1");
        if (StringUtils.isNotBlank((String)sha1)) {
            this.log.debug("Uploading SHA1 for file " + fileAbsolutePath + " : " + sha1);
            String sha1Url = uploadUrl + ".sha1" + DeploymentUrlUtils.buildMatrixParamsString(details.getProperties(), true);
            HttpPut putSha1 = new HttpPut(sha1Url);
            StringEntity sha1StringEntity = new StringEntity(sha1);
            ArtifactoryUploadResponse response = this.httpClient.upload(putSha1, (HttpEntity)sha1StringEntity);
            StatusLine sha1StatusLine = response.getStatusLine();
            int sha1StatusCode = sha1StatusLine.getStatusCode();
            if (sha1StatusCode != 201 && sha1StatusCode != 200) {
                throw new IOException("Failed to deploy SHA1 checksum. Status code: " + sha1StatusCode + this.getMessage(response));
            }
        }
        if (StringUtils.isNotBlank((String)(md5 = checksums.get("MD5")))) {
            this.log.debug("Uploading MD5 for file " + fileAbsolutePath + " : " + md5);
            String md5Url = uploadUrl + ".md5" + DeploymentUrlUtils.buildMatrixParamsString(details.getProperties(), true);
            HttpPut putMd5 = new HttpPut(md5Url);
            StringEntity md5StringEntity = new StringEntity(md5);
            ArtifactoryUploadResponse response = this.httpClient.upload(putMd5, (HttpEntity)md5StringEntity);
            StatusLine md5StatusLine = response.getStatusLine();
            int md5StatusCode = md5StatusLine.getStatusCode();
            if (md5StatusCode != 201 && md5StatusCode != 200) {
                throw new IOException("Failed to deploy MD5 checksum. Status code: " + md5StatusCode + this.getMessage(response));
            }
        }
    }

    private Map<String, String> getChecksumMap(DeployDetails details) throws IOException {
        HashMap<String, String> checksums = new HashMap<String, String>();
        ArrayList<String> checksumTypeList = new ArrayList<String>();
        if (StringUtils.isBlank((String)details.getMd5())) {
            checksumTypeList.add("MD5");
        } else {
            checksums.put("MD5", details.getMd5());
        }
        if (StringUtils.isBlank((String)details.getSha1())) {
            checksumTypeList.add("SHA1");
        } else {
            checksums.put("SHA1", details.getSha1());
        }
        if (!checksumTypeList.isEmpty()) {
            try {
                checksums.putAll(FileChecksumCalculator.calculateChecksums((File)details.getFile(), (String[])checksumTypeList.toArray(new String[checksumTypeList.size()])));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return checksums;
    }

    private void throwHttpIOException(String message, StatusLine statusLine) throws IOException {
        String errorMessage = message + " HTTP response code: " + statusLine.getStatusCode() + ". HTTP response message: " + statusLine.getReasonPhrase();
        throw new IOException(errorMessage);
    }

    private String getMessage(ArtifactoryUploadResponse response) {
        String responseMessage = "";
        if (response.getErrors() != null && StringUtils.isNotBlank((String)(responseMessage = this.getResponseMessage(response.getErrors())))) {
            responseMessage = " Response message: " + responseMessage;
        }
        return responseMessage;
    }

    private String getResponseMessage(List<ArtifactoryUploadResponse.Error> errorList) {
        if (errorList == null || errorList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("Artifactory returned the following errors: ");
        for (ArtifactoryUploadResponse.Error error : errorList) {
            builder.append("\n").append(error.getMessage()).append(" Status code: ").append(error.getStatus());
        }
        return builder.toString();
    }

    public void reportUsage(UsageReporter usageReporter) throws IOException {
        ArtifactoryVersion version = this.getArtifactoryVersion();
        if (version.isNotFound()) {
            throw new IOException("Could not get Artifactory version.");
        }
        if (!version.isAtLeast((Version)USAGE_ARTIFACTORY_MIN_VERSION)) {
            throw new IOException("Usage report is not supported on targeted Artifactory server.");
        }
        String url = this.artifactoryUrl + USAGE_API;
        String encodedUrl = ArtifactoryHttpClient.encodeUrl((String)url);
        String requestBody = new JsonSerializer<UsageReporter>().toJSON(usageReporter);
        StringEntity entity = new StringEntity(requestBody, "UTF-8");
        entity.setContentType(APPLICATION_JSON);
        HttpPost request = new HttpPost(encodedUrl);
        request.setEntity((HttpEntity)entity);
        try (CloseableHttpResponse httpResponse = this.httpClient.getHttpClient().execute((HttpUriRequest)request);){
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 200 && statusLine.getStatusCode() != 202) {
                throw new IOException(String.format("Artifactory response: %s %s", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
            }
        }
    }

    public void sendBuildRetention(BuildRetention buildRetention, String buildName, boolean async) throws IOException {
        String buildRetentionJson = this.toJsonString(buildRetention);
        String url = this.artifactoryUrl + BUILD_RETENTION_REST_URL + buildName + BUILD_RETENTION_REST_ASYNC_PARAM + async;
        HttpPost httpPost = new HttpPost(url);
        try {
            this.log.info(this.createBuildRetentionLogMsg(buildRetention, async));
            this.log.debug(buildRetentionJson);
            this.sendHttpEntityRequest((HttpEntityEnclosingRequestBase)httpPost, buildRetentionJson, APPLICATION_JSON);
        }
        catch (IOException e) {
            throw new IOException("Failed to execute build retention", e);
        }
    }

    public void sendBuildInfo(Build buildInfo, String platformUrl) throws IOException {
        this.log.debug("Sending build info: " + buildInfo);
        try {
            this.sendBuildInfo(this.buildInfoToJsonString(buildInfo), buildInfo.getProject());
        }
        catch (Exception e) {
            throw new IOException("Could not publish build-info", e);
        }
        String url = StringUtils.isNotBlank((String)platformUrl) ? ArtifactoryBuildInfoClient.createBuildInfoUrl(platformUrl, buildInfo.getName(), buildInfo.getNumber(), String.valueOf(buildInfo.getStartedMillis()), buildInfo.getProject()) : ArtifactoryBuildInfoClient.createBuildInfoUrl(this.artifactoryUrl, buildInfo.getName(), buildInfo.getNumber());
        this.log.info("Build successfully deployed. Browse it in Artifactory under " + url);
    }
}

