/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.IOException;
import java.util.List;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.AqlHelperBase;
import org.jfrog.build.extractor.clientConfiguration.util.BuildAqlHelper;
import org.jfrog.build.extractor.clientConfiguration.util.PatternAqlHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;

class ArtifactorySearcher {
    private ArtifactoryDependenciesClient client;
    private Log log;

    ArtifactorySearcher(ArtifactoryDependenciesClient client, Log log) {
        this.client = client;
        this.log = log;
    }

    List<AqlSearchResult.SearchEntry> SearchByFileSpec(FileSpec file) throws IOException {
        AqlHelperBase aqlHelper = null;
        this.log.info("Searching for artifacts...");
        switch (file.getSpecType()) {
            case PATTERN: {
                aqlHelper = new PatternAqlHelper(this.client, this.log, file);
                break;
            }
            case BUILD: {
                aqlHelper = new BuildAqlHelper(this.client, this.log, file);
                break;
            }
            case AQL: {
                aqlHelper = new AqlHelperBase(this.client, this.log, file);
            }
        }
        List<AqlSearchResult.SearchEntry> results = aqlHelper.run();
        this.log.info(String.format("Found %s artifacts.", results.size()));
        return results;
    }
}

