/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.dependency.pattern.PatternType;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.ZipUtils;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.ArtifactorySearcher;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloaderImpl;
import org.jfrog.build.extractor.clientConfiguration.util.PathsUtils;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;

public class DependenciesDownloaderHelper {
    public static final String SHA1_ALGORITHM_NAME = "sha1";
    public static final String MD5_ALGORITHM_NAME = "md5";
    private final DependenciesDownloader downloader;
    private final Log log;
    private static final int CONCURRENT_DOWNLOAD_THREADS = 3;
    public static final int MIN_SIZE_FOR_CONCURRENT_DOWNLOAD = 5120000;

    public DependenciesDownloaderHelper(DependenciesDownloader downloader, Log log) {
        this.downloader = downloader;
        this.log = log;
    }

    public DependenciesDownloaderHelper(ArtifactoryDependenciesClient client, String workingDirectory, Log log) {
        this.downloader = new DependenciesDownloaderImpl(client, workingDirectory, log);
        this.log = log;
    }

    public List<Dependency> downloadDependencies(Spec downloadSpec) throws IOException {
        ArtifactorySearcher searcher = new ArtifactorySearcher(this.downloader.getClient(), this.log);
        ArrayList<Dependency> resolvedDependencies = new ArrayList<Dependency>();
        for (FileSpec file : downloadSpec.getFiles()) {
            this.log.debug("Downloading dependencies using spec: \n" + file.toString());
            this.downloader.setFlatDownload(BooleanUtils.toBoolean((String)file.getFlat()));
            List<AqlSearchResult.SearchEntry> searchResults = searcher.SearchByFileSpec(file);
            Set<DownloadableArtifact> downloadableArtifacts = this.fetchDownloadableArtifactsFromResult(searchResults, Boolean.valueOf(file.getExplode()), file.getTarget());
            if (file.getSpecType() == FileSpec.SpecType.PATTERN) {
                this.replaceTargetPlaceholders(file.getPattern(), downloadableArtifacts, file.getTarget());
            }
            resolvedDependencies.addAll(this.downloadDependencies(downloadableArtifacts));
        }
        return resolvedDependencies;
    }

    private void replaceTargetPlaceholders(String searchPattern, Set<DownloadableArtifact> downloadableArtifacts, String target) {
        searchPattern = StringUtils.substringAfter((String)searchPattern, (String)"/");
        Pattern pattern = Pattern.compile(PathsUtils.pathToRegExp(searchPattern));
        target = StringUtils.defaultIfEmpty((String)target, (String)"");
        for (DownloadableArtifact artifact : downloadableArtifacts) {
            if (StringUtils.isEmpty((String)target) || target.endsWith("/")) {
                artifact.setTargetDirPath(PathsUtils.reformatRegexp(artifact.getFilePath(), target, pattern));
                continue;
            }
            String targetAfterReplacement = PathsUtils.reformatRegexp(artifact.getFilePath(), target, pattern);
            Map<String, String> targetFileName = PathsUtils.replaceFilesName(targetAfterReplacement, artifact.getRelativeDirPath());
            artifact.setRelativeDirPath(targetFileName.get("srcPath"));
            artifact.setTargetDirPath(targetFileName.get("targetPath"));
        }
    }

    private Set<DownloadableArtifact> fetchDownloadableArtifactsFromResult(List<AqlSearchResult.SearchEntry> searchResults, boolean explode, String target) {
        HashSet<DownloadableArtifact> downloadableArtifacts = new HashSet<DownloadableArtifact>();
        for (AqlSearchResult.SearchEntry searchEntry : searchResults) {
            String path = searchEntry.getPath().equals(".") ? "" : searchEntry.getPath() + "/";
            DownloadableArtifact downloadableArtifact = new DownloadableArtifact(StringUtils.stripEnd((String)this.downloader.getClient().getArtifactoryUrl(), (String)"/") + "/" + searchEntry.getRepo(), target, path + searchEntry.getName(), "", "", PatternType.NORMAL);
            downloadableArtifact.setExplode(explode);
            downloadableArtifacts.add(downloadableArtifact);
        }
        return downloadableArtifacts;
    }

    public List<Dependency> downloadDependencies(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        this.log.info("Beginning to resolve Build Info published dependencies.");
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        HashSet<DownloadableArtifact> downloadedArtifacts = new HashSet<DownloadableArtifact>();
        for (DownloadableArtifact downloadableArtifact : downloadableArtifacts) {
            Dependency dependency = this.downloadArtifact(downloadableArtifact);
            if (dependency == null) continue;
            dependencies.add(dependency);
            downloadedArtifacts.add(downloadableArtifact);
            this.explodeDependenciesIfNeeded(downloadableArtifact);
        }
        this.removeUnusedArtifactsFromLocal(downloadedArtifacts);
        this.log.info("Finished resolving Build Info published dependencies.");
        return dependencies;
    }

    private void explodeDependenciesIfNeeded(DownloadableArtifact downloadableArtifact) throws IOException {
        if (!downloadableArtifact.isExplode()) {
            return;
        }
        String fileDestination = this.downloader.getTargetDir(downloadableArtifact.getTargetDirPath(), downloadableArtifact.getRelativeDirPath());
        this.log.info("Extracting Archive: " + fileDestination);
        File sourceArchive = new File(fileDestination);
        File parentFile = FileUtils.getFile((String[])new String[]{fileDestination}).getParentFile();
        ZipUtils.extract((File)sourceArchive, (File)parentFile);
        this.log.info("Finished extracting archive to " + parentFile);
        this.log.debug("Deleting archive...");
        FileUtils.deleteQuietly((File)sourceArchive);
    }

    private void removeUnusedArtifactsFromLocal(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        HashSet<String> forDeletionFiles = new HashSet<String>();
        HashSet<String> allResolvesFiles = new HashSet<String>();
        for (DownloadableArtifact downloadableArtifact : downloadableArtifacts) {
            String fileDestination = this.downloader.getTargetDir(downloadableArtifact.getTargetDirPath(), downloadableArtifact.getRelativeDirPath());
            allResolvesFiles.add(fileDestination);
            if (!PatternType.DELETE.equals((Object)downloadableArtifact.getPatternType())) continue;
            forDeletionFiles.add(fileDestination);
        }
        this.downloader.removeUnusedArtifactsFromLocal(allResolvesFiles, forDeletionFiles);
    }

    private Dependency downloadArtifact(DownloadableArtifact downloadableArtifact) throws IOException {
        String filePath = downloadableArtifact.getFilePath();
        String matrixParams = downloadableArtifact.getMatrixParameters();
        String uri = downloadableArtifact.getRepoUrl() + '/' + filePath;
        String uriWithParams = StringUtils.isBlank((String)matrixParams) ? uri : uri + ';' + matrixParams;
        ArtifactMetaData artifactMetaData = this.downloadArtifactMetaData(uriWithParams);
        if (StringUtils.isBlank((String)artifactMetaData.getMd5()) && StringUtils.isBlank((String)artifactMetaData.getSha1())) {
            return null;
        }
        return this.downloadArtifact(downloadableArtifact, artifactMetaData, uriWithParams, filePath);
    }

    Dependency downloadArtifact(DownloadableArtifact downloadableArtifact, ArtifactMetaData artifactMetaData, String uriWithParams, String filePath) throws IOException {
        String remotePath;
        String fileDestination = this.downloader.getTargetDir(downloadableArtifact.getTargetDirPath(), downloadableArtifact.getRelativeDirPath());
        Dependency dependencyResult = this.getDependencyLocally(artifactMetaData, fileDestination, remotePath = downloadableArtifact.getRepoUrl() + "/" + filePath);
        if (dependencyResult != null) {
            return dependencyResult;
        }
        try {
            Map<String, String> checksumsMap;
            this.log.info(String.format("Downloading '%s'...", uriWithParams));
            Map<String, String> map = checksumsMap = artifactMetaData.getSize() >= 5120000L && artifactMetaData.isAcceptRange() ? this.downloadFileConcurrently(uriWithParams, artifactMetaData.getSize(), fileDestination, filePath) : this.downloadFile(uriWithParams, fileDestination);
            if (checksumsMap == null) {
                throw new IOException("Received null checksums map for downloaded file.");
            }
            dependencyResult = this.validateChecksumsAndBuildDependency(checksumsMap, artifactMetaData, filePath, fileDestination, remotePath);
            this.log.info(String.format("Successfully downloaded '%s' to '%s'", uriWithParams, fileDestination));
            return dependencyResult;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    protected Map<String, String> downloadFile(String uriWithParams, String fileDestination) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    protected Map<String, String> downloadFileConcurrently(String uriWithParams, long fileSize, String fileDestination, String filePath) throws Exception {
        File tempDir = Files.createTempDir();
        String tempPath = tempDir.getPath() + File.separatorChar + filePath;
        try {
            String[] downloadedFilesPaths = this.doConcurrentDownload(fileSize, uriWithParams, tempPath);
            try (InputStream inputStream = this.concatenateFilesToSingleStream(downloadedFilesPaths);){
                Map<String, String> map = this.downloader.saveDownloadedFile(inputStream, fileDestination);
                return map;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtils.deleteDirectory((File)tempDir);
        }
    }

    private String[] doConcurrentDownload(long fileSize, final String uriWithParams, String tempPath) throws Exception {
        final MutableBoolean errorOccurred = new MutableBoolean(false);
        String[] downloadedFilesPaths = new String[3];
        long chunkSize = fileSize / 3L;
        Thread[] workers = new Thread[3];
        long start = 0L;
        long end = chunkSize + fileSize % 3L - 1L;
        for (int i = 0; i < 3; ++i) {
            String downloadPath;
            final HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Range", "bytes=" + start + "-" + end);
            downloadedFilesPaths[i] = downloadPath = tempPath + String.valueOf(i);
            workers[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        DependenciesDownloaderHelper.this.saveRequestToFile(uriWithParams, downloadPath, headers);
                    }
                    catch (Exception e) {
                        errorOccurred.setValue(true);
                        DependenciesDownloaderHelper.this.printErrorToLog(e, downloadPath, uriWithParams);
                    }
                }
            });
            workers[i].setName("downloader_" + i);
            workers[i].start();
            start = end + 1L;
            end += chunkSize;
        }
        for (Thread worker : workers) {
            worker.join();
        }
        if (errorOccurred.booleanValue()) {
            throw new Exception(String.format("Error occurred while downloading %s, please refer to logs for more information", uriWithParams));
        }
        return downloadedFilesPaths;
    }

    private void saveRequestToFile(String uriWithParams, String fileDestination, Map<String, String> headers) throws IOException {
        try (CloseableHttpResponse httpResponse = this.downloader.getClient().downloadArtifact(uriWithParams, headers);
             InputStream inputStream = httpResponse.getEntity().getContent();){
            DependenciesDownloaderHelper.saveInputStreamToFile(inputStream, fileDestination);
        }
    }

    private InputStream concatenateFilesToSingleStream(String[] downloadedFilesPaths) throws FileNotFoundException {
        InputStream inputStream = new FileInputStream(downloadedFilesPaths[0]);
        if (downloadedFilesPaths.length < 2) {
            return inputStream;
        }
        for (int i = 1; i < downloadedFilesPaths.length; ++i) {
            inputStream = new SequenceInputStream(inputStream, new FileInputStream(downloadedFilesPaths[i]));
        }
        return inputStream;
    }

    private Dependency getDependencyLocally(ArtifactMetaData fileMetaData, String localPath, String remotePath) throws IOException {
        if (this.downloader.isFileExistsLocally(localPath, fileMetaData.getMd5(), fileMetaData.getSha1())) {
            this.log.info(String.format("The file '%s' exists locally.", localPath));
            return new DependencyBuilder().md5(fileMetaData.getMd5()).sha1(fileMetaData.getSha1()).id(localPath.substring(localPath.lastIndexOf(String.valueOf(IOUtils.DIR_SEPARATOR)) + 1)).localPath(localPath).remotePath(remotePath).build();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ArtifactMetaData downloadArtifactMetaData(String url) throws IOException {
        try (CloseableHttpResponse response = this.downloader.getClient().getArtifactMetadata(url);){
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            ArtifactMetaData artifactMetaData = new ArtifactMetaData();
            artifactMetaData.setMd5(this.getHeaderContentFromResponse((HttpResponse)response, "X-Checksum-Md5"));
            artifactMetaData.setSha1(this.getHeaderContentFromResponse((HttpResponse)response, "X-Checksum-Sha1"));
            artifactMetaData.setSize(NumberUtils.toLong((String)this.getHeaderContentFromResponse((HttpResponse)response, "Content-Length")));
            artifactMetaData.setAcceptRange("bytes".equals(this.getHeaderContentFromResponse((HttpResponse)response, "Accept-Ranges")));
            ArtifactMetaData artifactMetaData2 = artifactMetaData;
            return artifactMetaData2;
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private String validateMd5Checksum(String metadataMd5, String calculatedMd5) throws IOException {
        if (!StringUtils.equals((String)metadataMd5, (String)calculatedMd5)) {
            String errorMessage = String.format("Calculated MD5 checksum is different from original, Original: '%s' Calculated: '%s'", metadataMd5, calculatedMd5);
            throw new IOException(errorMessage);
        }
        return metadataMd5 == null ? "" : metadataMd5;
    }

    private String validateSha1Checksum(String metadataSha1, String calculatedSha1) throws IOException {
        if (!StringUtils.equals((String)metadataSha1, (String)calculatedSha1)) {
            String errorMessage = String.format("Calculated SHA-1 checksum is different from original, Original: '%s' Calculated: '%s'", metadataSha1, calculatedSha1);
            throw new IOException(errorMessage);
        }
        return metadataSha1 == null ? "" : metadataSha1;
    }

    private String getHeaderContentFromResponse(HttpResponse response, String headerName) {
        String headerContent = null;
        Header header = response.getFirstHeader(headerName);
        if (header != null) {
            headerContent = header.getValue();
        }
        return headerContent;
    }

    private Dependency validateChecksumsAndBuildDependency(Map<String, String> checksumsMap, ArtifactMetaData artifactMetaData, String filePath, String fileDestination, String remotePath) throws IOException {
        String md5 = this.validateMd5Checksum(artifactMetaData.getMd5(), checksumsMap.get(MD5_ALGORITHM_NAME));
        String sha1 = this.validateSha1Checksum(artifactMetaData.getSha1(), checksumsMap.get(SHA1_ALGORITHM_NAME));
        return new DependencyBuilder().md5(md5).sha1(sha1).id(filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1)).localPath(fileDestination).remotePath(remotePath).build();
    }

    public static File saveInputStreamToFile(InputStream inputStream, String filePath) throws IOException {
        File dest = new File(filePath);
        if (dest.exists()) {
            dest.delete();
        } else {
            dest.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(dest);
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)fileOutputStream);
            File file = dest;
            return file;
        }
        catch (IOException e) {
            throw new IOException(String.format("Could not create or write to file: %s", dest.getCanonicalPath()), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    private void printErrorToLog(Exception e, String downloadPath, String uriWithParams) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        this.log.error(String.format("[Thread %s] downloading %s as part of file %s threw an exception: %s", Thread.currentThread().getName(), downloadPath, uriWithParams, sw.toString()));
    }

    protected static class ArtifactMetaData {
        private String sha1;
        private String md5;
        private long size;
        private boolean acceptRange;

        protected ArtifactMetaData() {
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public String getSha1() {
            return this.sha1;
        }

        public void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public boolean isAcceptRange() {
            return this.acceptRange;
        }

        public void setAcceptRange(boolean acceptRange) {
            this.acceptRange = acceptRange;
        }
    }
}

