/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.ArtifactorySearcher;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;

public class EditPropertiesHelper {
    private final ArtifactoryDependenciesClient client;
    private final Log log;
    private final String artifactoryEditPropsUrl;

    public EditPropertiesHelper(ArtifactoryDependenciesClient client, Log log) {
        this.client = client;
        this.log = log;
        this.artifactoryEditPropsUrl = StringUtils.stripEnd((String)client.getArtifactoryUrl(), (String)"/") + "/api/storage/";
    }

    public boolean editProperties(Spec spec, EditPropertiesActionType editType, String props) throws IOException {
        ArtifactorySearcher searcher = new ArtifactorySearcher(this.client, this.log);
        boolean propertiesSet = false;
        for (FileSpec file : spec.getFiles()) {
            this.log.debug("Editing properties using spec: \n" + file.toString());
            propertiesSet = editType == EditPropertiesActionType.SET ? this.setPropertiesOnResults(searcher.SearchByFileSpec(file), props) || propertiesSet : this.deletePropertiesOnResults(searcher.SearchByFileSpec(file), props) || propertiesSet;
        }
        return propertiesSet;
    }

    private boolean setPropertiesOnResults(List<AqlSearchResult.SearchEntry> searchResults, String props) throws IOException {
        boolean propertiesSet = false;
        this.log.info("Setting properties...");
        this.validateSetProperties(props);
        for (AqlSearchResult.SearchEntry result : searchResults) {
            String url = this.buildEntryUrl(result);
            this.log.info(String.format("Setting the properties: '%s', on artifact: %s", props, url));
            this.client.setProperties(url, props);
            propertiesSet = true;
        }
        this.log.info("Done setting properties.");
        return propertiesSet;
    }

    private boolean deletePropertiesOnResults(List<AqlSearchResult.SearchEntry> searchResults, String props) throws IOException {
        boolean propertiesSet = false;
        this.log.info("Deleting properties...");
        for (AqlSearchResult.SearchEntry result : searchResults) {
            String url = this.buildEntryUrl(result);
            this.log.info(String.format("Deleting the properties: '%s', on artifact: %s", props, url));
            this.client.deleteProperties(url, props);
            propertiesSet = true;
        }
        this.log.info("Done deleting properties.");
        return propertiesSet;
    }

    private String buildEntryUrl(AqlSearchResult.SearchEntry result) {
        String path = result.getPath().equals(".") ? "" : result.getPath() + "/";
        return this.artifactoryEditPropsUrl + result.getRepo() + "/" + path + result.getName();
    }

    private void validateSetProperties(String props) throws IOException {
        for (String prop : props.trim().split(";")) {
            if (prop.isEmpty()) continue;
            String key = StringUtils.substringBefore((String)prop, (String)"=");
            if (key.isEmpty()) {
                throw new IOException("Setting properties: Every property must have a key.");
            }
            String values = StringUtils.substringAfter((String)prop, (String)"=");
            if (!values.isEmpty() && StringUtils.countMatches((String)values, (String)",") != values.length()) continue;
            throw new IOException("Setting properties: Every property must have at least one value.");
        }
    }

    public static enum EditPropertiesActionType {
        SET,
        DELETE;

    }
}

