/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.AqlHelperBase;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;

public class PatternAqlHelper
extends AqlHelperBase {
    PatternAqlHelper(ArtifactoryDependenciesClient client, Log log, FileSpec file) throws IOException {
        super(client, log, file);
    }

    @Override
    public void convertFileSpecToAql(FileSpec file) throws IOException {
        super.buildQueryAdditionalParts(file);
        boolean recursive = !"false".equalsIgnoreCase(file.getRecursive());
        this.queryBody = PatternAqlHelper.buildAqlSearchQuery(file.getPattern(), file.getExcludePatterns(), file.getExclusions(), recursive, file.getProps());
    }

    static String buildAqlSearchQuery(String searchPattern, String[] excludePatterns, String[] exclusions, boolean recursive, String props) {
        searchPattern = PatternAqlHelper.prepareSearchPattern(searchPattern);
        List<RepoPathFile> repoPathFileTriples = PatternAqlHelper.createRepoPathFileTriples(searchPattern, recursive);
        boolean includeRoot = StringUtils.countMatches((String)searchPattern, (String)"/") < 2;
        int triplesSize = repoPathFileTriples.size();
        String excludeQuery = PatternAqlHelper.buildExcludeQuery(excludePatterns, exclusions, triplesSize == 0 || recursive, recursive);
        String nePath = PatternAqlHelper.buildNePathQuery(triplesSize == 0 || includeRoot);
        String json = String.format("{%s\"$or\":[", PatternAqlHelper.buildPropsQuery(props) + nePath + excludeQuery);
        StringBuilder aqlQuery = new StringBuilder(json);
        aqlQuery.append(PatternAqlHelper.handleRepoPathFileTriples(repoPathFileTriples, triplesSize)).append("]}");
        return aqlQuery.toString();
    }

    static String handleRepoPathFileTriples(List<RepoPathFile> repoPathFiles, int repoPathFileSize) {
        String query = "";
        for (int i = 0; i < repoPathFileSize; ++i) {
            query = query + PatternAqlHelper.buildInnerQuery(repoPathFiles.get(i));
            if (i + 1 >= repoPathFileSize) continue;
            query = query + ",";
        }
        return query;
    }

    private static String prepareSearchPattern(String pattern) {
        if (pattern.endsWith("/")) {
            pattern = pattern + "*";
        }
        return pattern.replaceAll("[()]", "");
    }

    private static boolean isSlashPrecedeAsterisk(int asteriskIndex, int slashIndex) {
        return slashIndex < asteriskIndex && slashIndex >= 0;
    }

    static List<RepoPathFile> createRepoPathFileTriples(String searchPattern, boolean recursive) {
        int firstSlashIndex = searchPattern.indexOf("/");
        ArrayList<Integer> asteriskIndices = new ArrayList<Integer>();
        for (int i = 0; i < searchPattern.length(); ++i) {
            if (searchPattern.charAt(i) != '*') continue;
            asteriskIndices.add(i);
        }
        if (!asteriskIndices.isEmpty() && !PatternAqlHelper.isSlashPrecedeAsterisk((Integer)asteriskIndices.get(0), firstSlashIndex)) {
            int asteriskIndex;
            ArrayList<RepoPathFile> triples = new ArrayList<RepoPathFile>();
            int lastRepoAsteriskIndex = 0;
            Iterator iterator = asteriskIndices.iterator();
            while (iterator.hasNext() && !PatternAqlHelper.isSlashPrecedeAsterisk(asteriskIndex = ((Integer)iterator.next()).intValue(), firstSlashIndex)) {
                String repo = searchPattern.substring(0, asteriskIndex + 1);
                String newPattern = searchPattern.substring(asteriskIndex);
                int slashCount = StringUtils.countMatches((String)newPattern, (String)"/");
                int asterixCount = StringUtils.countMatches((String)newPattern, (String)"*");
                if (!(slashCount <= 1 && asterixCount <= 1 || (newPattern = newPattern.replaceFirst("^\\*/", "")).startsWith("*"))) {
                    newPattern = "*" + newPattern;
                }
                triples.addAll(PatternAqlHelper.createPathFilePairs(repo, newPattern, recursive));
                lastRepoAsteriskIndex = asteriskIndex + 1;
            }
            if (lastRepoAsteriskIndex < firstSlashIndex) {
                String repo = searchPattern.substring(0, firstSlashIndex);
                String newPattern = searchPattern.substring(firstSlashIndex + 1);
                triples.addAll(PatternAqlHelper.createPathFilePairs(repo, newPattern, recursive));
            } else if (firstSlashIndex < 0 && !StringUtils.endsWith((String)searchPattern, (String)"*")) {
                triples.addAll(PatternAqlHelper.createPathFilePairs(searchPattern, "*", recursive));
            }
            return triples;
        }
        if (firstSlashIndex < 0) {
            return PatternAqlHelper.createPathFilePairs(searchPattern, "*", recursive);
        }
        String repo = searchPattern.substring(0, firstSlashIndex);
        String pattern = searchPattern.substring(firstSlashIndex + 1);
        return PatternAqlHelper.createPathFilePairs(repo, pattern, recursive);
    }

    static List<RepoPathFile> createPathFilePairs(String repo, String pattern, boolean recursive) {
        String name;
        String path;
        ArrayList<RepoPathFile> res = new ArrayList<RepoPathFile>();
        if (pattern.equals("*")) {
            res.add(new RepoPathFile(repo, PatternAqlHelper.getDefaultPath(recursive), "*"));
            return res;
        }
        ArrayList<RepoPathFile> triples = new ArrayList<RepoPathFile>();
        int slashIndex = pattern.lastIndexOf("/");
        if (slashIndex < 0) {
            if (recursive && pattern.startsWith("*")) {
                path = "";
                name = pattern;
            } else {
                path = "";
                name = pattern;
                triples.add(new RepoPathFile(repo, ".", pattern));
            }
        } else {
            path = pattern.substring(0, slashIndex);
            name = pattern.substring(slashIndex + 1);
            triples.add(new RepoPathFile(repo, path, name));
        }
        if (!recursive) {
            return triples;
        }
        if (name.equals("*")) {
            triples.add(new RepoPathFile(repo, path + "/*", "*"));
            return triples;
        }
        PatternAqlHelper.populateTriplesWithRepoPathFile(triples, repo, path, name);
        return triples;
    }

    private static void populateTriplesWithRepoPathFile(List<RepoPathFile> triples, String repo, String path, String name) {
        String[] nameSplit = name.split("\\*", -1);
        for (int i = 0; i < nameSplit.length - 1; ++i) {
            String str = "";
            for (int j = 0; j < nameSplit.length; ++j) {
                String namePart = nameSplit[j];
                if (j > 0) {
                    str = str + "*";
                }
                str = j == i ? str + nameSplit[i] + "*/" : str + namePart;
            }
            String[] slashSplit = str.split("/", -1);
            String filePath = slashSplit[0];
            String fileName = slashSplit[1];
            if (fileName.equals("")) {
                fileName = "*";
            }
            if (!path.equals("") && !path.endsWith("/")) {
                path = path + "/";
            }
            triples.add(new RepoPathFile(repo, path + filePath, fileName));
        }
    }

    private static String getDefaultPath(boolean recursive) {
        if (recursive) {
            return "*";
        }
        return ".";
    }

    private static String buildExcludeQuery(String[] excludePatterns, String[] exclusions, boolean useLocalPath, boolean recursive) {
        if (ArrayUtils.isEmpty((Object[])exclusions) && ArrayUtils.isEmpty((Object[])excludePatterns)) {
            return "";
        }
        ArrayList<RepoPathFile> excludeTriples = new ArrayList<RepoPathFile>();
        if (exclusions != null && exclusions.length > 0) {
            for (String exclusion : exclusions) {
                excludeTriples.addAll(PatternAqlHelper.createRepoPathFileTriples(PatternAqlHelper.prepareSearchPattern(exclusion), recursive));
            }
        } else {
            for (String excludePattern : excludePatterns) {
                excludeTriples.addAll(PatternAqlHelper.createPathFilePairs("", PatternAqlHelper.prepareSearchPattern(excludePattern), recursive));
            }
        }
        String excludeQuery = "";
        for (RepoPathFile excludeTriple : excludeTriples) {
            String excludePath = excludeTriple.getPath();
            if (!useLocalPath && excludePath.equals(".")) {
                excludePath = "*";
            }
            String excludeRepoStr = "";
            if (StringUtils.isNotEmpty((String)excludeTriple.getRepo())) {
                excludeRepoStr = String.format("\"repo\":{\"$nmatch\":\"%s\"},", excludeTriple.getRepo());
            }
            excludeQuery = excludeQuery + String.format("\"$or\":[{%s\"path\":{\"$nmatch\":\"%s\"},\"name\":{\"$nmatch\":\"%s\"}}],", excludeRepoStr, excludePath, excludeTriple.getFile());
        }
        return excludeQuery;
    }

    private static String buildPropsQuery(String props) {
        if (props == null || props.equals("")) {
            return "";
        }
        String[] propList = props.split(";");
        StringBuilder query = new StringBuilder();
        for (String prop : propList) {
            String[] keyVal = prop.split("=");
            if (keyVal.length != 2) {
                System.out.print("Invalid props pattern: " + prop);
            }
            String key = keyVal[0];
            String value = keyVal[1];
            query.append("\"@").append(key).append("\": {\"$match\" : \"").append(value).append("\"},");
        }
        return query.toString();
    }

    private static String buildInnerQuery(RepoPathFile triple) {
        return String.format("{\"$and\":[{\"repo\":%s,\"path\":%s,\"name\":%s}]}", PatternAqlHelper.getAqlValue(triple.getRepo()), PatternAqlHelper.getAqlValue(triple.getPath()), PatternAqlHelper.getAqlValue(triple.getFile()));
    }

    private static String getAqlValue(String value) {
        String aqlValuePattern = value.contains("*") ? "{\"$match\":\"%s\"}" : "\"%s\"";
        return String.format(aqlValuePattern, value);
    }

    private static String buildNePathQuery(boolean includeRoot) {
        return includeRoot ? "" : "\"path\":{\"$ne\":\".\"},";
    }

    static class RepoPathFile {
        private String repo;
        private String path;
        private String file;

        RepoPathFile(String repo, String path, String file) {
            this.repo = repo;
            this.path = path;
            this.file = file;
        }

        public String getRepo() {
            return this.repo;
        }

        public void setRepo(String repo) {
            this.repo = repo;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RepoPathFile)) {
                return false;
            }
            RepoPathFile that = (RepoPathFile)o;
            return Objects.equals(this.repo, that.repo) && Objects.equals(this.path, that.path) && Objects.equals(this.file, that.file);
        }

        public String toString() {
            return "RepoPathFile{repo='" + this.repo + '\'' + ", path='" + this.path + '\'' + ", file='" + this.file + '\'' + '}';
        }
    }
}

