/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.packageManager;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;

public abstract class PackageManagerExtractor
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract Build execute();

    public void executeAndSaveBuildInfo(ArtifactoryClientConfiguration clientConfiguration) throws RuntimeException {
        CommonUtils.handleJavaTmpdirProperty();
        Build build = this.execute();
        if (build == null) {
            return;
        }
        PackageManagerUtils.collectEnvIfNeeded(clientConfiguration, build);
        PackageManagerExtractor.saveBuildInfoToFile(clientConfiguration, build);
    }

    static void saveBuildInfoToFile(ArtifactoryClientConfiguration clientConfiguration, Build build) {
        String generatedBuildInfoPath = clientConfiguration.info.getGeneratedBuildInfoFilePath();
        if (StringUtils.isBlank((String)generatedBuildInfoPath)) {
            return;
        }
        try {
            BuildInfoExtractorUtils.saveBuildInfoToFile(build, new File(generatedBuildInfoPath));
        }
        catch (Exception e) {
            clientConfiguration.getLog().error("Failed writing build info to file: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected static void validateRepoExists(ArtifactoryBaseClient client, String repo, String repoNotSpecifiedMsg) throws IOException {
        if (StringUtils.isBlank((String)repo)) {
            throw new IllegalArgumentException(repoNotSpecifiedMsg);
        }
        if (!client.isRepoExist(repo)) {
            throw new IOException("Repo " + repo + " doesn't exist");
        }
    }
}

