/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.builder.dependency.BuildDependencyBuilder;
import org.jfrog.build.api.builder.dependency.BuildPatternArtifactsRequestBuilder;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.api.dependency.BuildPatternArtifacts;
import org.jfrog.build.api.dependency.BuildPatternArtifactsRequest;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.dependency.PatternArtifact;
import org.jfrog.build.api.dependency.PatternResult;
import org.jfrog.build.api.dependency.pattern.BuildDependencyPattern;
import org.jfrog.build.api.dependency.pattern.DependencyPattern;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.PatternFactory;
import org.jfrog.build.extractor.clientConfiguration.util.PublishedItemsHelper;

public class BuildDependenciesHelper {
    private DependenciesDownloader downloader;
    private Log log;

    public BuildDependenciesHelper(DependenciesDownloader downloader, Log log) {
        this.downloader = downloader;
        this.log = log;
    }

    public List<BuildDependency> retrieveBuildDependencies(String resolvePattern) throws IOException, InterruptedException {
        if (StringUtils.isBlank((String)resolvePattern)) {
            return Collections.emptyList();
        }
        List<String> patternLines = PublishedItemsHelper.parsePatternsFromProperty(resolvePattern);
        if (patternLines.isEmpty()) {
            return Collections.emptyList();
        }
        this.log.info("Beginning to resolve Build Info build dependencies.");
        Map<String, Map<String, List<BuildDependencyPattern>>> buildDependencies = this.getBuildDependencies(patternLines);
        List<BuildPatternArtifactsRequest> artifactsRequests = this.toArtifactsRequests(buildDependencies);
        List<BuildPatternArtifacts> artifactsResponses = this.downloader.getArtifactoryManager().retrievePatternArtifacts(artifactsRequests);
        HashSet<BuildDependency> result = new HashSet<BuildDependency>();
        this.downloader.download(this.collectArtifactsToDownload(buildDependencies, artifactsRequests, artifactsResponses, result));
        this.log.info("Finished resolving Build Info build dependencies.");
        return new ArrayList<BuildDependency>(result);
    }

    private Map<String, Map<String, List<BuildDependencyPattern>>> getBuildDependencies(List<String> patternLines) {
        HashMap<String, Map<String, List<BuildDependencyPattern>>> buildsMap = new HashMap<String, Map<String, List<BuildDependencyPattern>>>();
        for (String patternLine : patternLines) {
            String buildNumber;
            List dependencyPatternList;
            DependencyPattern dependencyPattern = PatternFactory.create(patternLine);
            if (!(dependencyPattern instanceof BuildDependencyPattern)) continue;
            BuildDependencyPattern buildDependencyPattern = (BuildDependencyPattern)dependencyPattern;
            String buildName = buildDependencyPattern.getBuildName();
            Map numbersMap = (Map)buildsMap.get(buildName);
            if (numbersMap == null) {
                buildsMap.put(buildName, new HashMap());
                numbersMap = (Map)buildsMap.get(buildName);
            }
            if ((dependencyPatternList = (List)numbersMap.get(buildNumber = buildDependencyPattern.getBuildNumber())) == null) {
                numbersMap.put(buildNumber, new LinkedList());
                dependencyPatternList = (List)numbersMap.get(buildNumber);
            }
            dependencyPatternList.add(buildDependencyPattern);
        }
        return buildsMap;
    }

    private List<BuildPatternArtifactsRequest> toArtifactsRequests(Map<String, Map<String, List<BuildDependencyPattern>>> dependencyPatterns) {
        LinkedList<BuildPatternArtifactsRequest> artifactsRequests = new LinkedList<BuildPatternArtifactsRequest>();
        for (String buildName : dependencyPatterns.keySet()) {
            Map<String, List<BuildDependencyPattern>> buildNumbers = dependencyPatterns.get(buildName);
            for (String buildNumber : buildNumbers.keySet()) {
                List<BuildDependencyPattern> buildDependencyPatterns = buildNumbers.get(buildNumber);
                BuildPatternArtifactsRequestBuilder builder = new BuildPatternArtifactsRequestBuilder().buildName(buildName).buildNumber(buildNumber);
                for (BuildDependencyPattern buildDependencyPattern : buildDependencyPatterns) {
                    builder.pattern(buildDependencyPattern.getPattern());
                }
                artifactsRequests.add(builder.build());
            }
        }
        return artifactsRequests;
    }

    private Set<DownloadableArtifact> collectArtifactsToDownload(Map<String, Map<String, List<BuildDependencyPattern>>> dependencyPatterns, List<BuildPatternArtifactsRequest> artifactsRequests, List<BuildPatternArtifacts> artifactsResponses, Set<BuildDependency> buildDependencies) {
        HashSet<DownloadableArtifact> downloadableArtifacts = new HashSet<DownloadableArtifact>();
        this.verifySameSize(artifactsRequests, artifactsResponses);
        for (int i = 0; i < artifactsRequests.size(); ++i) {
            BuildPatternArtifacts artifacts = artifactsResponses.get(i);
            if (artifacts == null) continue;
            List<BuildDependencyPattern> buildDependencyPatterns = dependencyPatterns.get(artifacts.getBuildName()).get(artifactsRequests.get(i).getBuildNumber());
            for (int j = 0; j < buildDependencyPatterns.size(); ++j) {
                BuildDependencyPattern buildDependencyPattern = buildDependencyPatterns.get(j);
                if (!buildDependencyPattern.getBuildName().equals(artifacts.getBuildName())) {
                    throw new IllegalArgumentException(String.format("Build names don't match: [%s] != [%s]", buildDependencyPattern.getBuildName(), artifacts.getBuildName()));
                }
                String message = String.format("Dependency on build [%s], number [%s]", buildDependencyPattern.getBuildName(), buildDependencyPattern.getBuildNumber());
                if (artifacts.getBuildNumber() == null) {
                    this.log.info(message + " - no results found, check correctness of dependency build name and build number.");
                    continue;
                }
                PatternResult patternResult = (PatternResult)artifacts.getPatternResults().get(j);
                List patternArtifacts = patternResult.getPatternArtifacts();
                this.log.info(message + String.format(", pattern [%s] - [%s] result%s found.", buildDependencyPattern.getPattern(), patternArtifacts.size(), patternArtifacts.size() == 1 ? "" : "s"));
                for (PatternArtifact patternArtifact : patternArtifacts) {
                    String uri = patternArtifact.getUri();
                    int indexOfFirstSlash = uri.indexOf(47);
                    assert (indexOfFirstSlash > 0) : String.format("Failed to locate '/' in [%s]", uri);
                    String repoUrl = patternArtifact.getArtifactoryUrl() + '/' + uri.substring(0, indexOfFirstSlash);
                    String filePath = uri.substring(indexOfFirstSlash + 1);
                    downloadableArtifacts.add(new DownloadableArtifact(repoUrl, buildDependencyPattern.getTargetDirectory(), filePath, buildDependencyPattern.getMatrixParams(), buildDependencyPattern.getPattern(), buildDependencyPattern.getPatternType()));
                }
                if (patternArtifacts.isEmpty()) continue;
                BuildDependency buildDependency = new BuildDependencyBuilder().name(artifacts.getBuildName()).number(artifacts.getBuildNumber()).url(artifacts.getUrl()).started(artifacts.getStarted()).build();
                buildDependencies.add(buildDependency);
            }
        }
        return downloadableArtifacts;
    }

    private void verifySameSize(List l1, List l2) {
        if (l1.size() != l2.size()) {
            throw new IllegalArgumentException(String.format("List sizes don't match: [%s] != [%s]", l1.size(), l2.size()));
        }
    }
}

