/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec.validator;

import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;

public abstract class SpecsValidator {
    public abstract void validate(Spec var1, Log var2) throws IOException;

    static void validateQueryInputs(FileSpec fileSpec) throws IOException {
        boolean isExclusion;
        boolean isAql = StringUtils.isNotBlank((String)fileSpec.getAql());
        boolean isPattern = StringUtils.isNotBlank((String)fileSpec.getPattern());
        boolean isExcludePattern = !ArrayUtils.isEmpty((Object[])fileSpec.getExcludePatterns()) && StringUtils.isNotBlank((String)fileSpec.getExcludePattern(0));
        boolean bl = isExclusion = !ArrayUtils.isEmpty((Object[])fileSpec.getExclusions()) && StringUtils.isNotBlank((String)fileSpec.getExclusion(0));
        if (isAql && isPattern) {
            throw new IllegalArgumentException("Spec can't contain both AQL and Pattern keys");
        }
        if (isAql && (isExcludePattern || isExclusion)) {
            throw new IllegalArgumentException("Spec can't contain both AQL and ExcludePatterns or Exclusions keys");
        }
        if (isExcludePattern && isExclusion) {
            throw new IllegalArgumentException("Spec can't contain both Exclusions and ExcludePatterns keys");
        }
    }
}

