/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.PublishBuildInfo;
import org.jfrog.build.extractor.clientConfiguration.client.response.GetAllBuildNumbersResponse;

public class GetAllBuildNumbers
extends JFrogService<GetAllBuildNumbersResponse> {
    private final String buildName;
    private final String project;

    public GetAllBuildNumbers(String buildName, String project, Log logger) {
        super(logger);
        this.buildName = buildName;
        this.project = project;
    }

    @Override
    public HttpRequestBase createRequest() {
        String apiEndPoint = String.format("%s/%s%s", "api/build", GetAllBuildNumbers.encodeUrl(this.buildName), PublishBuildInfo.getProjectQueryParam(this.project));
        return new HttpGet(apiEndPoint);
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = this.getMapper().readValue(stream, GetAllBuildNumbersResponse.class);
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        if (this.statusCode == 404) {
            this.result = new GetAllBuildNumbersResponse();
        } else {
            GetAllBuildNumbers.throwException(entity, this.getStatusCode());
        }
    }
}

