/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.distribution.services;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.response.DistributionStatusResponse;

public class GetDistributionStatus
extends JFrogService<DistributionStatusResponse> {
    private static final String GET_STATUS_ENDPOINT = "api/v1/release_bundle";
    private final String trackerId;
    private final String version;
    private final String name;

    public GetDistributionStatus(String name, String version, String trackerId, Log logger) {
        super(logger);
        this.name = name;
        this.version = version;
        this.trackerId = trackerId;
    }

    @Override
    protected void ensureRequirements(JFrogHttpClient client) throws IOException {
        if (StringUtils.isBlank((String)this.name)) {
            throw new IOException("Release bundle name is mandatory");
        }
        if (StringUtils.isBlank((String)this.version)) {
            throw new IOException("Release bundle version is mandatory");
        }
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        return new HttpGet(this.createUrl());
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = this.getMapper().readValue(stream, DistributionStatusResponse.class);
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        if (this.getStatusCode() == 404) {
            this.result = null;
            return;
        }
        super.handleUnsuccessfulResponse(entity);
    }

    private String createUrl() {
        String url = GET_STATUS_ENDPOINT;
        if (StringUtils.isEmpty((String)this.name)) {
            return url + "/distribution";
        }
        url = url + "/" + this.name;
        if (StringUtils.isEmpty((String)this.version)) {
            return url + "/distribution";
        }
        url = url + "/" + this.version + "/distribution";
        if (StringUtils.isNotEmpty((String)this.trackerId)) {
            return url + "/" + this.trackerId;
        }
        return url;
    }
}

