/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.clientConfiguration.client.VoidJFrogService;
import org.jfrog.build.extractor.clientConfiguration.util.JsonUtils;

public class PublishBuildInfo
extends VoidJFrogService {
    public static final String BUILD_BROWSE_URL = "/webapp/builds";
    private static final String BUILD_REST_URL = "/api/build";
    public static final String BUILD_BROWSE_PLATFORM_URL = "/ui/builds";
    private static final String BUILD_PROJECT_PARAM = "?project=";
    private final Build buildInfo;
    private final String platformUrl;
    private String buildInfoJson;

    public PublishBuildInfo(Build buildInfo, String platformUrl, Log logger) {
        super(logger);
        this.buildInfo = buildInfo;
        this.platformUrl = platformUrl;
    }

    public static String getProjectQueryParam(String project, String prefix) {
        if (StringUtils.isNotEmpty((String)project)) {
            return prefix + PublishBuildInfo.encodeUrl(project);
        }
        return "";
    }

    public static String getProjectQueryParam(String project) {
        return PublishBuildInfo.getProjectQueryParam(project, BUILD_PROJECT_PARAM);
    }

    public static String createBuildInfoUrl(String platformUrl, String buildName, String buildNumber, String timeStamp, String project, boolean encode) {
        if (encode) {
            buildName = PublishBuildInfo.encodeUrl(buildName);
            buildNumber = PublishBuildInfo.encodeUrl(buildNumber);
        }
        return String.format("%s/%s/%s/%s/%s", platformUrl + BUILD_BROWSE_PLATFORM_URL, buildName, buildNumber, timeStamp, "published" + PublishBuildInfo.getProjectQueryParam(project));
    }

    public static String createBuildInfoUrl(String artifactoryUrl, String buildName, String buildNumber, boolean encode) {
        if (encode) {
            buildName = PublishBuildInfo.encodeUrl(buildName);
            buildNumber = PublishBuildInfo.encodeUrl(buildNumber);
        }
        return String.format("%s/%s/%s", artifactoryUrl + BUILD_BROWSE_URL, buildName, buildNumber);
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Could not build the build-info object.");
        PublishBuildInfo.throwException(entity, this.getStatusCode());
    }

    @Override
    protected void ensureRequirements(JFrogHttpClient client) throws IOException {
        if (this.buildInfo == null) {
            return;
        }
        this.buildInfoJson = JsonUtils.toJsonString(this.buildInfo);
    }

    @Override
    public HttpRequestBase createRequest() {
        HttpPut request = new HttpPut(BUILD_REST_URL + PublishBuildInfo.getProjectQueryParam(this.buildInfo.getProject()));
        StringEntity stringEntity = new StringEntity(this.buildInfoJson, "UTF-8");
        stringEntity.setContentType("application/vnd.org.jfrog.artifactory+json");
        request.setEntity((HttpEntity)stringEntity);
        this.log.info("Deploying build info...");
        return request;
    }

    @Override
    public Void execute(JFrogHttpClient client) throws IOException {
        super.execute(client);
        String url = StringUtils.isNotBlank((String)this.platformUrl) ? PublishBuildInfo.createBuildInfoUrl(this.platformUrl, this.buildInfo.getName(), this.buildInfo.getNumber(), String.valueOf(this.buildInfo.getStartedMillis()), this.buildInfo.getProject(), true) : PublishBuildInfo.createBuildInfoUrl(client.getUrl(), this.buildInfo.getName(), this.buildInfo.getNumber(), true);
        this.log.info("Build successfully deployed. Browse it in Artifactory under " + url);
        return (Void)this.result;
    }
}

