/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec.validator;

import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.Spec;
import org.jfrog.build.extractor.clientConfiguration.util.spec.validator.SpecsValidator;

public class SearchBasedSpecValidator
extends SpecsValidator {
    @Override
    public void validate(Spec spec, Log log) throws IOException {
        if (spec.getFiles() == null || spec.getFiles().length == 0) {
            throw new IllegalArgumentException("Spec must contain at least one fileSpec.");
        }
        for (FileSpec fileSpec : spec.getFiles()) {
            boolean isExcludePatterns;
            boolean isAql = StringUtils.isNotBlank((String)fileSpec.getAql());
            boolean isPattern = StringUtils.isNotBlank((String)fileSpec.getPattern());
            boolean isBuild = StringUtils.isNotBlank((String)fileSpec.getBuild());
            boolean bl = isExcludePatterns = !ArrayUtils.isEmpty((Object[])fileSpec.getExcludePatterns()) && StringUtils.isNotBlank((String)fileSpec.getExcludePattern(0));
            if (!(isAql || isPattern || isBuild)) {
                throw new IllegalArgumentException("A search based Spec must contain AQL or Pattern, and/or Build keys.");
            }
            SearchBasedSpecValidator.validateQueryInputs(fileSpec);
            if (!isExcludePatterns) continue;
            log.warn("The 'excludePatterns' File Spec property is deprecated.\nPlease use the 'exclusions' File Spec property instead.\nUnlike excludePatterns, exclusions take into account the repository as part of the pattern.\nFor example: \n\"excludePatterns\": [\"a.zip\"]\ncan be translated to\n\"exclusions\": [\"repo-name/a.zip\"]\nor\n\"exclusions\": [\"*/a.zip\"]");
        }
    }
}

