/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloaderHelper;
import org.jfrog.build.extractor.clientConfiguration.util.EditPropertiesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecDeploymentConsumer;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecDeploymentProducer;
import org.jfrog.build.extractor.producerConsumer.ConsumerRunnableBase;
import org.jfrog.build.extractor.producerConsumer.ProducerConsumerExecutor;
import org.jfrog.build.extractor.producerConsumer.ProducerRunnableBase;
import org.jfrog.filespecs.FileSpec;
import org.jfrog.filespecs.FileSpecsValidation;
import org.jfrog.filespecs.utils.Log;

public class SpecsHelper {
    private static final int DEFAULT_NUMBER_OF_THREADS = 3;
    private final org.jfrog.build.api.util.Log log;

    public SpecsHelper(org.jfrog.build.api.util.Log log) {
        this.log = log;
    }

    public List<Artifact> uploadArtifactsBySpec(String uploadSpec, File workspace, Map<String, String> buildProperties, ArtifactoryManagerBuilder artifactoryManagerBuilder) throws Exception {
        return this.uploadArtifactsBySpec(uploadSpec, 3, workspace, SpecsHelper.createMultiMap(buildProperties), artifactoryManagerBuilder);
    }

    private static <K, V> Multimap<K, V> createMultiMap(Map<K, V> input) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (Map.Entry<K, V> entry : input.entrySet()) {
            multimap.put(entry.getKey(), entry.getValue());
        }
        return multimap;
    }

    public List<Artifact> uploadArtifactsBySpec(String uploadSpec, int numberOfThreads, File workspace, Multimap<String, String> buildProperties, ArtifactoryManagerBuilder artifactoryManagerBuilder) throws Exception {
        FileSpec fileSpec = FileSpec.fromString((String)uploadSpec);
        FileSpecsValidation.validateUploadFileSpec((FileSpec)fileSpec, (Log)this.log);
        try (ArtifactoryManager artifactoryManager = artifactoryManagerBuilder.build();){
            ProducerRunnableBase[] producerRunnable = new ProducerRunnableBase[]{new SpecDeploymentProducer(fileSpec, workspace, buildProperties)};
            ConsumerRunnableBase[] consumerRunnables = new ConsumerRunnableBase[numberOfThreads];
            for (int i = 0; i < numberOfThreads; ++i) {
                consumerRunnables[i] = new SpecDeploymentConsumer(artifactoryManager);
            }
            ProducerConsumerExecutor deploymentExecutor = new ProducerConsumerExecutor(this.log, producerRunnable, consumerRunnables, 10);
            deploymentExecutor.start();
            Set<DeployDetails> deployedArtifacts = ((SpecDeploymentProducer)producerRunnable[0]).getDeployedArtifacts();
            List<Artifact> list = this.convertDeployDetailsToArtifacts(deployedArtifacts);
            return list;
        }
    }

    private List<Artifact> convertDeployDetailsToArtifacts(Set<DeployDetails> details) {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (DeployDetails detail : details) {
            String ext = FilenameUtils.getExtension((String)detail.getFile().getName());
            ArtifactBuilder artifactBuilder = new ArtifactBuilder(detail.getFile().getName());
            artifactBuilder.md5(detail.getMd5()).sha1(detail.getSha1()).type(ext).localPath(detail.getFile().getAbsolutePath()).remotePath(detail.getArtifactPath()).build();
            result.add(artifactBuilder.build());
        }
        return result;
    }

    public List<Dependency> downloadArtifactsBySpec(String spec, ArtifactoryManager client, String targetDirectory) throws IOException {
        CommonUtils.handleJavaTmpdirProperty();
        DependenciesDownloaderHelper helper = new DependenciesDownloaderHelper(client, targetDirectory, this.log);
        FileSpec fileSpec = FileSpec.fromString((String)spec);
        FileSpecsValidation.validateSearchBasedFileSpec((FileSpec)fileSpec);
        return helper.downloadDependencies(fileSpec);
    }

    public boolean editPropertiesBySpec(String spec, ArtifactoryManager artifactoryManager, EditPropertiesHelper.EditPropertiesActionType editType, String props) throws IOException {
        EditPropertiesHelper helper = new EditPropertiesHelper(artifactoryManager, this.log);
        FileSpec fileSpec = FileSpec.fromString((String)spec);
        FileSpecsValidation.validateSearchBasedFileSpec((FileSpec)fileSpec);
        return helper.editProperties(fileSpec, editType, props);
    }

    public static ArrayListMultimap<String, String> getPropertiesMap(String props) {
        ArrayListMultimap propertiesMap = ArrayListMultimap.create();
        SpecsHelper.fillPropertiesMap(props, (ArrayListMultimap<String, String>)propertiesMap);
        return propertiesMap;
    }

    public static void fillPropertiesMap(String props, ArrayListMultimap<String, String> propertiesMap) {
        if (StringUtils.isBlank((String)props)) {
            return;
        }
        for (String prop : props.trim().split(";")) {
            String key = StringUtils.substringBefore((String)prop, (String)"=");
            String[] values = StringUtils.substringAfter((String)prop, (String)"=").split(",");
            propertiesMap.putAll((Object)key, Arrays.asList(values));
        }
    }
}

