/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class GeneralInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String componentId = "";
    private String pkgType = "";
    private String path = "";
    private String sha1 = "";

    public GeneralInfo() {
    }

    public GeneralInfo(String componentId, String path, String pkgType) {
        this.componentId = componentId;
        this.path = path;
        this.pkgType = pkgType;
    }

    public String getGroupId() {
        int colonMatches = StringUtils.countMatches((String)this.componentId, (String)":");
        if (colonMatches != 2) {
            return "";
        }
        return this.componentId.substring(0, this.componentId.indexOf(":"));
    }

    public String getArtifactId() {
        int colonMatches = StringUtils.countMatches((String)this.componentId, (String)":");
        if (colonMatches < 1 || colonMatches > 2) {
            return "";
        }
        int indexOfColon = this.componentId.indexOf(":");
        if (colonMatches == 1) {
            return this.componentId.substring(0, indexOfColon);
        }
        return this.componentId.substring(indexOfColon + 1, this.componentId.lastIndexOf(":"));
    }

    public String getVersion() {
        int colonMatches = StringUtils.countMatches((String)this.componentId, (String)":");
        if (colonMatches < 1 || colonMatches > 2) {
            return "";
        }
        return this.componentId.substring(this.componentId.lastIndexOf(":") + 1);
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getPath() {
        return this.path;
    }

    public String getPkgType() {
        return this.pkgType;
    }

    public String getSha1() {
        return this.sha1;
    }

    public GeneralInfo componentId(String componentId) {
        this.componentId = componentId;
        return this;
    }

    public GeneralInfo path(String path) {
        this.path = path;
        return this;
    }

    public GeneralInfo pkgType(String pkgType) {
        this.pkgType = pkgType;
        return this;
    }

    public GeneralInfo sha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }
}

