/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.Vcs;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.util.UrlUtils;

public class GitUtils {
    private static File getDotGit(File file) {
        if (file == null) {
            return null;
        }
        File dotGit = new File(file, ".git");
        if (dotGit.exists()) {
            return dotGit;
        }
        return GitUtils.getDotGit(file.getParentFile());
    }

    public static Vcs extractVcs(File workingDir, Log log) throws IOException {
        log.debug("Extracting Vcs details from the .git directory.");
        File dotGit = GitUtils.getDotGit(workingDir);
        if (dotGit == null) {
            log.debug("Could not find the .git directory.");
            return new Vcs();
        }
        if (dotGit.isFile()) {
            dotGit = GitUtils.getSubmoduleDotGit(dotGit);
        }
        Vcs vcs = new Vcs();
        vcs.setRevision(GitUtils.extractVcsRevision(dotGit, log));
        vcs.setUrl(GitUtils.extractVcsUrl(dotGit, log));
        return vcs;
    }

    private static File getSubmoduleDotGit(File dotGit) throws IOException {
        String dotGitRelativePathString = GitUtils.extractSubmoduleDotGitPath(dotGit);
        String dotGitAbsolutePathString = dotGit.getParent() + File.separator + dotGitRelativePathString;
        File dotGitFile = new File(dotGitAbsolutePathString);
        if (!dotGitFile.exists()) {
            throw new IOException("Could not find the .git directory of a submodule.");
        }
        return dotGitFile;
    }

    private static String extractSubmoduleDotGitPath(File dotGit) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(dotGit));){
            String line = br.readLine();
            if (line != null && line.startsWith("gitdir: ")) {
                String string = line.substring(line.indexOf(":") + 1).trim();
                return string;
            }
        }
        throw new IOException("Failed to parse .git path for submodule.");
    }

    private static String extractVcsUrl(File dotGit, Log log) throws IOException {
        File pathToConfig = new File(dotGit, "config");
        String originalUrl = "";
        try (BufferedReader br = new BufferedReader(new FileReader(pathToConfig));){
            String line;
            boolean isNextLineUrl = false;
            while ((line = br.readLine()) != null) {
                if (isNextLineUrl && (line = line.trim()).startsWith("url")) {
                    String[] split = line.split("=");
                    if (split.length < 2) {
                        throw new IOException("Failed to parse .git config");
                    }
                    originalUrl = split[1].trim();
                    break;
                }
                if (!line.equals("[remote \"origin\"]")) continue;
                isNextLineUrl = true;
            }
        }
        if (!originalUrl.endsWith(".git")) {
            originalUrl = originalUrl + ".git";
        }
        String maskedUrl = UrlUtils.removeCredentialsFromUrl(originalUrl);
        log.debug("Fetched url from git config: " + maskedUrl);
        return maskedUrl;
    }

    private static String extractVcsRevision(File dotGit, Log log) throws IOException {
        RevisionOrRef revisionOrRef;
        block33: {
            revisionOrRef = GitUtils.getRevisionOrBranchPath(dotGit);
            if (StringUtils.isNotEmpty((CharSequence)revisionOrRef.revision)) {
                log.debug("Fetched revision from git config: " + revisionOrRef.revision);
                return revisionOrRef.revision;
            }
            File pathToRef = new File(dotGit, revisionOrRef.ref);
            if (pathToRef.exists()) {
                try (BufferedReader br = new BufferedReader(new FileReader(pathToRef));){
                    String line = br.readLine();
                    if (line != null) {
                        log.debug("Fetched revision from git config: " + line.trim());
                        String string = line.trim();
                        return string;
                    }
                    break block33;
                }
            }
            File pathToPackedRefs = new File(dotGit, "packed-refs");
            if (pathToPackedRefs.exists()) {
                try (BufferedReader br = new BufferedReader(new FileReader(pathToPackedRefs));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (!line.endsWith(revisionOrRef.ref)) continue;
                        String[] split = line.split("\\s+");
                        String string = split[0];
                        return string;
                    }
                }
            }
        }
        log.warn("Failed fetching revision from git config, from ref: " + revisionOrRef.ref);
        return "";
    }

    private static RevisionOrRef getRevisionOrBranchPath(File dotGit) throws IOException {
        File pathToHead = new File(dotGit, "HEAD");
        RevisionOrRef result = new RevisionOrRef();
        try (BufferedReader br = new BufferedReader(new FileReader(pathToHead));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("ref")) {
                    String[] split = line.split(":");
                    if (split.length < 2) {
                        throw new IOException("Failed to parse .git config");
                    }
                    result.ref = split[1].trim();
                    RevisionOrRef revisionOrRef = result;
                    return revisionOrRef;
                }
                result.revision = line;
            }
        }
        return result;
    }

    private static class RevisionOrRef {
        private String revision;
        private String ref;

        private RevisionOrRef() {
        }
    }
}

