/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.scan.Severity;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Issue
implements Comparable<Issue> {
    private Severity severity = Severity.Normal;
    private List<String> fixedVersions;
    private String component = "";
    private String description;
    private String summary;
    private String cve;

    public Issue() {
    }

    public Issue(String description, Severity severity, String summary, List<String> fixedVersions, String cve) {
        this.description = description;
        this.severity = severity;
        this.summary = summary;
        this.fixedVersions = fixedVersions;
        this.cve = cve;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<String> getFixedVersions() {
        return this.fixedVersions;
    }

    public void setFixedVersions(List<String> fixedVersions) {
        this.fixedVersions = fixedVersions;
    }

    public String getCve() {
        return this.cve;
    }

    @JsonIgnore
    public boolean isTopSeverity() {
        return this.getSeverity() == Severity.Critical;
    }

    @JsonIgnore
    public boolean isHigherSeverityThan(Issue o) {
        return this.getSeverity().isHigherThan(o.getSeverity());
    }

    @Override
    public int compareTo(@Nonnull Issue otherIssue) {
        return Integer.compare(this.hashCode(), Objects.hashCode(otherIssue));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Issue otherIssue = (Issue)other;
        if (StringUtils.isEmpty((CharSequence)this.component)) {
            return StringUtils.equals((CharSequence)this.description, (CharSequence)otherIssue.description) && StringUtils.equals((CharSequence)this.summary, (CharSequence)otherIssue.summary);
        }
        return StringUtils.equals((CharSequence)this.component, (CharSequence)otherIssue.component) && StringUtils.equals((CharSequence)this.summary, (CharSequence)otherIssue.summary);
    }

    public int hashCode() {
        return Objects.hash(this.summary, this.component, this.description);
    }
}

