/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class License {
    private static final String UNKNOWN_LICENCE_FULL_NAME = "Unknown license";
    private static final String UNKNOWN_LICENCE_NAME = "Unknown";
    private List<String> components = new ArrayList<String>();
    private final String fullName;
    private final String name;
    private List<String> moreInfoUrl = new ArrayList<String>();
    private boolean violate;

    public License() {
        this.fullName = UNKNOWN_LICENCE_FULL_NAME;
        this.name = UNKNOWN_LICENCE_NAME;
    }

    public License(List<String> components, String fullName, String name, List<String> moreInfoUrl) {
        this(components, fullName, name, moreInfoUrl, false);
    }

    public License(List<String> components, String fullName, String name, List<String> moreInfoUrl, boolean violate) {
        this.components = components;
        this.fullName = StringUtils.trim((String)fullName);
        this.name = StringUtils.trim((String)name);
        this.moreInfoUrl = moreInfoUrl;
        this.violate = violate;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isViolate() {
        return this.violate;
    }

    public void setViolate(boolean violate) {
        this.violate = violate;
    }

    public List<String> getMoreInfoUrl() {
        return this.moreInfoUrl;
    }

    @JsonIgnore
    public boolean isFullNameEmpty() {
        return StringUtils.isBlank((CharSequence)this.fullName) || this.fullName.equals(UNKNOWN_LICENCE_FULL_NAME);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        License otherLicense = (License)other;
        return StringUtils.equals((CharSequence)this.fullName, (CharSequence)otherLicense.fullName) && StringUtils.equals((CharSequence)this.name, (CharSequence)otherLicense.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fullName);
    }

    public String toString() {
        return this.name;
    }
}

