/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.PublishBuildInfo;
import org.jfrog.build.extractor.clientConfiguration.client.response.GetBuildInfoResponse;

public class GetBuildInfo
extends JFrogService<BuildInfo> {
    private final String buildName;
    private final String buildNumber;
    private final String project;

    public GetBuildInfo(String buildName, String buildNumber, String project, Log logger) {
        super(logger);
        this.buildName = buildName;
        this.buildNumber = buildNumber;
        this.project = project;
    }

    @Override
    public HttpRequestBase createRequest() {
        String apiEndPoint = String.format("%s/%s/%s%s", "api/build", GetBuildInfo.encodeUrl(this.buildName), GetBuildInfo.encodeUrl(this.buildNumber), PublishBuildInfo.getProjectQueryParam(this.project));
        return new HttpGet(apiEndPoint);
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        Build build = ((GetBuildInfoResponse)this.getMapper().readValue(stream, GetBuildInfoResponse.class)).getBuildInfo();
        this.result = build == null ? null : BuildInfo.ToBuildInfo(build);
    }
}

