/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.spec;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.PathsUtils;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;

public class UploadSpecHelper {
    private static final String SHA1 = "SHA1";
    private static final String MD5 = "MD5";

    public static DeployDetails buildDeployDetails(String targetPath, File artifactFile, String uploadTarget, String explode, String props, Multimap<String, String> buildProperties) throws IOException, NoSuchAlgorithmException {
        Map checksums;
        String path = UploadSpecHelper.wildcardCalculateTargetPath(targetPath, artifactFile);
        path = StringUtils.replace((String)path, (String)"//", (String)"/");
        try {
            checksums = FileChecksumCalculator.calculateChecksums((File)artifactFile, (String[])new String[]{SHA1, MD5});
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(String.format("Could not find checksum algorithm for %s or %s.", SHA1, MD5), e);
        }
        DeployDetails.Builder builder = new DeployDetails.Builder().file(artifactFile).artifactPath(path).targetRepository(UploadSpecHelper.getRepositoryKey(uploadTarget)).md5((String)checksums.get(MD5)).sha1((String)checksums.get(SHA1)).explode(BooleanUtils.toBoolean((String)explode)).addProperties((Multimap<String, String>)SpecsHelper.getPropertiesMap(props)).packageType(DeployDetails.PackageType.GENERIC);
        if (buildProperties != null && !buildProperties.isEmpty()) {
            builder.addProperties(buildProperties);
        }
        return builder.build();
    }

    public static String wildcardCalculateTargetPath(String targetPattern, File artifactFile) {
        if (targetPattern.endsWith("/") || targetPattern.equals("")) {
            return StringUtils.removeStart((String)(targetPattern + UploadSpecHelper.calculateTargetRelativePath(artifactFile)), (String)"/");
        }
        return targetPattern;
    }

    public static String calculateTargetRelativePath(File artifactFile) {
        String relativePath = artifactFile.getAbsolutePath();
        String parentDir = artifactFile.getParent();
        if (!StringUtils.isBlank((CharSequence)parentDir)) {
            relativePath = StringUtils.removeStart((String)artifactFile.getAbsolutePath(), (String)parentDir);
        }
        relativePath = FilenameUtils.separatorsToUnix((String)relativePath);
        relativePath = StringUtils.removeStart((String)relativePath, (String)"/");
        return relativePath;
    }

    public static String getRelativeToWsPath(String absolutePath, String workspacePath) {
        String absoluteFilePath = absolutePath.replace("\\", "/");
        workspacePath = workspacePath.replace("\\", "/");
        return absoluteFilePath.substring(workspacePath.length() + 1);
    }

    public static String prepareExcludePattern(String[] excludePatterns, boolean isWildcard, boolean recursive) {
        StringBuilder patternSb = new StringBuilder();
        if (!ArrayUtils.isEmpty((Object[])excludePatterns)) {
            for (String pattern : excludePatterns) {
                if (StringUtils.isBlank((CharSequence)pattern)) continue;
                if (isWildcard) {
                    pattern = PathsUtils.pathToRegExp(pattern);
                }
                if (recursive && pattern.endsWith(File.pathSeparator)) {
                    pattern = pattern + ".*";
                }
                patternSb.append("(").append(pattern).append(")|");
            }
            if (patternSb.length() > 0) {
                patternSb.deleteCharAt(patternSb.length() - 1);
            }
        }
        return patternSb.toString();
    }

    protected static String getUploadPath(File file, Pattern pathPattern, String targetPath, boolean isFlat, boolean isAbsolutePath, File workspaceDir, boolean isTargetDirectory) {
        String sourcePath;
        String fileTargetPath = targetPath;
        if (isTargetDirectory && !isFlat) {
            fileTargetPath = UploadSpecHelper.calculateFileTargetPath(workspaceDir, file, targetPath);
        }
        if (isAbsolutePath) {
            if (!isFlat) {
                fileTargetPath = isTargetDirectory ? targetPath + file.getPath() : targetPath;
            }
            sourcePath = file.getPath();
        } else {
            sourcePath = UploadSpecHelper.getRelativePath(workspaceDir, file);
        }
        return PathsUtils.reformatRegexp(sourcePath, fileTargetPath.replace('\\', '/'), pathPattern);
    }

    public static Multimap<String, File> getUploadPathsMap(List<File> files, File workspaceDir, String targetPath, boolean isFlat, Pattern regexPattern, boolean isAbsolutePath) {
        HashMultimap filePathsMap = HashMultimap.create();
        boolean isTargetDirectory = StringUtils.endsWith((CharSequence)targetPath, (CharSequence)"/");
        for (File file : files) {
            String fileTargetPath = UploadSpecHelper.getUploadPath(file, regexPattern, targetPath, isFlat, isAbsolutePath, workspaceDir, isTargetDirectory);
            filePathsMap.put((Object)fileTargetPath, (Object)file);
        }
        return filePathsMap;
    }

    public static String getWildcardBaseDir(File workspaceDir, String pattern) {
        String baseDir = UploadSpecHelper.getWildcardAbsolutePattern(workspaceDir, pattern);
        baseDir = StringUtils.substringBefore((String)baseDir, (String)"*");
        baseDir = StringUtils.substringBefore((String)baseDir, (String)"?");
        baseDir = baseDir.substring(0, baseDir.lastIndexOf("/") + 1);
        baseDir = UploadSpecHelper.removeParenthesis(baseDir);
        return UploadSpecHelper.removeParenthesisEscapeChar(baseDir);
    }

    public static String getRegexBaseDir(File workspaceDir, String pattern) throws FileNotFoundException {
        String baseDir = UploadSpecHelper.getRegexpAbsolutePattern(workspaceDir, pattern);
        if (StringUtils.isEmpty((CharSequence)(baseDir = UploadSpecHelper.getExistingPath(baseDir)))) {
            throw new FileNotFoundException("Could not find any base path in the pattern: " + pattern);
        }
        if (!baseDir.endsWith("/")) {
            baseDir = baseDir + "/";
        }
        return baseDir;
    }

    public static String prepareRegexPattern(File workspaceDir, String pattern, String baseDir) {
        String absolutePattern = UploadSpecHelper.getRegexpAbsolutePattern(workspaceDir, pattern);
        String newPattern = UploadSpecHelper.cleanRegexpPattern(absolutePattern, baseDir);
        newPattern = UploadSpecHelper.removeLeadingSeparator(newPattern);
        if (pattern.endsWith("/")) {
            newPattern = newPattern + ".*";
        }
        return newPattern;
    }

    public static String prepareWildcardPattern(File workspaceDir, String pattern, String baseDir) {
        String absolutePattern = UploadSpecHelper.getWildcardAbsolutePattern(workspaceDir, pattern);
        String newPattern = StringUtils.substringAfter((String)UploadSpecHelper.removeParenthesisEscapeChar(UploadSpecHelper.removeParenthesis(absolutePattern)), (String)baseDir);
        newPattern = UploadSpecHelper.removeLeadingSeparator(newPattern);
        if (pattern.endsWith("/")) {
            newPattern = newPattern + "*";
        }
        return newPattern;
    }

    private static String removeLeadingSeparator(String newPattern) {
        if (newPattern.startsWith("/")) {
            newPattern = newPattern.substring(1);
        }
        return newPattern;
    }

    public static String getRelativePath(File base, File file) {
        int len;
        String filePathToCompare;
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        basePath = UploadSpecHelper.ensureEndsWithSeparator(basePath);
        int lastSeparatorIndex = 0;
        String basePathToCompare = basePath.toLowerCase();
        if (basePathToCompare.equals(UploadSpecHelper.ensureEndsWithSeparator(filePathToCompare = filePath.toLowerCase()))) {
            return ".";
        }
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != File.separatorChar) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != File.separatorChar) continue;
            relativePath.append("..");
            relativePath.append(File.separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    public static String calculateFileTargetPath(File patternDir, File file, String targetPath) {
        String relativePath = UploadSpecHelper.getRelativePath(patternDir, file);
        relativePath = UploadSpecHelper.stripFileNameFromPath(relativePath);
        if (targetPath.length() == 0) {
            return relativePath;
        }
        if (relativePath.length() == 0) {
            return targetPath;
        }
        return targetPath + '/' + relativePath;
    }

    public static String getLocalPath(String path) {
        if ("".equals(path = StringUtils.substringAfter((String)path, (String)"/"))) {
            return "/";
        }
        return path;
    }

    private static String getRegexpAbsolutePattern(File workspaceDir, String pattern) {
        if (new File(pattern).isAbsolute()) {
            return pattern;
        }
        String escapedWorkspaceDir = PathsUtils.escapeRegexChars(workspaceDir.getAbsolutePath().replace("\\", "/"));
        return escapedWorkspaceDir + "/" + pattern;
    }

    private static String getWildcardAbsolutePattern(File workspaceDir, String pattern) {
        if (new File(pattern).isAbsolute()) {
            return pattern;
        }
        return UploadSpecHelper.escapeParentheses(workspaceDir.getAbsolutePath().replace("\\", "/")) + "/" + pattern;
    }

    private static String getExistingPath(String baseDir) {
        baseDir = PathsUtils.substringBeforeFirstRegex(UploadSpecHelper.removeParenthesis(baseDir));
        while (!new File(baseDir).isDirectory() && baseDir.contains("/")) {
            baseDir = StringUtils.substringBeforeLast((String)baseDir, (String)"/");
        }
        return baseDir;
    }

    private static String removeParenthesisEscapeChar(String baseDir) {
        return baseDir.replace("\\)", ")").replace("\\(", "(");
    }

    private static String removeParenthesis(String baseDir) {
        baseDir = PathsUtils.removeUnescapedChar(baseDir, Character.valueOf("(".charAt(0)));
        baseDir = PathsUtils.removeUnescapedChar(baseDir, Character.valueOf(")".charAt(0)));
        return baseDir;
    }

    private static String escapeParentheses(String path) {
        return path.replace("(", "\\(").replace(")", "\\)");
    }

    private static String cleanRegexpPattern(String absolutePattern, String baseDir) {
        String separator = "/";
        while (baseDir.contains(separator)) {
            baseDir = StringUtils.substringAfter((String)baseDir, (String)separator);
            absolutePattern = StringUtils.substringAfter((String)absolutePattern, (String)separator);
        }
        return UploadSpecHelper.cleanUnopenedParenthesis(absolutePattern);
    }

    private static String stripFileNameFromPath(String relativePath) {
        File file = new File(relativePath);
        return file.getPath().substring(0, file.getPath().length() - file.getName().length());
    }

    private static String cleanUnopenedParenthesis(String pattern) {
        int length = pattern.length();
        int numberOfUnclosedParenthesis = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            if (c == ")".charAt(0)) {
                if (numberOfUnclosedParenthesis <= 0) continue;
                --numberOfUnclosedParenthesis;
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
            if (c != "(".charAt(0)) continue;
            ++numberOfUnclosedParenthesis;
        }
        return stringBuilder.toString();
    }

    private static String ensureEndsWithSeparator(String s) {
        return StringUtils.endsWith((CharSequence)s, (CharSequence)File.separator) ? s : s + File.separator;
    }

    private static String getRepositoryKey(String path) {
        return StringUtils.substringBefore((String)path, (String)"/");
    }
}

