/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;

public class PrefixPropertyHandler {
    protected final Map<String, String> props;
    protected final Log log;
    private final String prefix;

    public PrefixPropertyHandler(Log log, Map<String, String> props) {
        this(log, props, "");
    }

    public PrefixPropertyHandler(PrefixPropertyHandler root, String prefix) {
        this(root.log, root.props, prefix);
    }

    private PrefixPropertyHandler(Log log, Map<String, String> props, String prefix) {
        this.log = log;
        this.props = props;
        this.prefix = prefix;
    }

    public Log getLog() {
        return this.log;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDeprecatedPrefix() {
        return "artifactory." + this.prefix;
    }

    public String getStringValue(String key) {
        return this.getStringValue(key, null);
    }

    public String getStringValue(String key, String def) {
        String value = this.getValueWithFallback(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return def;
    }

    public void setStringValue(String key, String value) {
        if (value == null) {
            this.props.remove(this.prefix + key);
        } else {
            this.props.put(this.prefix + key, value);
        }
    }

    public Boolean getBooleanValue(String key, Boolean def) {
        Boolean result;
        String value = this.getValueWithFallback(key);
        Boolean bl = result = value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
        if (result != null) {
            return result;
        }
        return def;
    }

    public void setBooleanValue(String key, Boolean value) {
        if (value == null) {
            this.props.remove(this.prefix + key);
        } else {
            this.props.put(this.prefix + key, value.toString());
        }
    }

    public Integer getIntegerValue(String key) {
        return this.getIntegerValue(key, null);
    }

    public Integer getIntegerValue(String key, Integer def) {
        Integer result = this.getInteger(key);
        if (result != null) {
            return result;
        }
        return def;
    }

    private Integer getInteger(String key) {
        Integer result;
        String s = this.getValueWithFallback(key);
        if (s != null && !StringUtils.isNumeric((CharSequence)s)) {
            this.log.debug("Property '" + key + "' is not of numeric value '" + s + "'");
            result = null;
        } else {
            result = s == null ? null : Integer.valueOf(Integer.parseInt(s));
        }
        return result;
    }

    private String getValueWithFallback(String key) {
        String value = this.props.get("artifactory." + this.prefix + key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return this.props.get(this.prefix + key);
    }

    public void setIntegerValue(String key, Integer value) {
        if (value == null) {
            this.props.remove(this.prefix + key);
        } else {
            this.props.put(this.prefix + key, value.toString());
        }
    }

    public Map<String, String> getProps() {
        return this.props;
    }
}

