/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloaderHelper;

public class DependenciesDownloaderImpl
implements DependenciesDownloader {
    private final ArtifactoryManager artifactoryManager;
    private File workingDirectory;
    private Log log;
    private boolean flatDownload = false;

    public DependenciesDownloaderImpl(ArtifactoryManager artifactoryManager, String workingDirectory, Log log) {
        this.workingDirectory = new File(workingDirectory);
        this.log = log;
        this.flatDownload = false;
        this.artifactoryManager = artifactoryManager;
    }

    @Override
    public ArtifactoryManager getArtifactoryManager() {
        return this.artifactoryManager;
    }

    @Override
    public List<Dependency> download(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        DependenciesDownloaderHelper helper = new DependenciesDownloaderHelper(this, this.log);
        return helper.downloadDependencies(downloadableArtifacts);
    }

    @Override
    public String getTargetDir(String targetDir, String relativeDir) throws IOException {
        String downloadFileRelativePath = this.flatDownload && relativeDir.contains("/") ? StringUtils.substringAfterLast((String)relativeDir, (String)"/") : relativeDir;
        return FilenameUtils.concat((String)this.workingDirectory.getPath(), (String)FilenameUtils.concat((String)targetDir, (String)downloadFileRelativePath));
    }

    @Override
    public Map<String, String> saveDownloadedFile(InputStream is, String filePath) throws IOException {
        File dest = DependenciesDownloaderHelper.saveInputStreamToFile(is, filePath);
        try {
            return FileChecksumCalculator.calculateChecksums((File)dest, (String[])new String[]{"MD5", "SHA1", "SHA-256"});
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format("Could not find checksum algorithm: %s", e.getLocalizedMessage()), e);
        }
    }

    @Override
    public boolean isFileExistsLocally(String filePath, String md5, String sha1) throws IOException {
        File dest = new File(filePath);
        if (!dest.exists()) {
            return false;
        }
        if (dest.isDirectory()) {
            throw new IOException(String.format("File can't override an existing directory: %s", dest.toString()));
        }
        try {
            boolean isExists;
            Map checksumsMap = FileChecksumCalculator.calculateChecksums((File)dest, (String[])new String[]{"MD5", "SHA1"});
            boolean bl = isExists = checksumsMap != null && StringUtils.isNotBlank((CharSequence)md5) && StringUtils.equals((CharSequence)md5, (CharSequence)((CharSequence)checksumsMap.get("MD5"))) && StringUtils.isNotBlank((CharSequence)sha1) && StringUtils.equals((CharSequence)sha1, (CharSequence)((CharSequence)checksumsMap.get("SHA1")));
            if (isExists) {
                return true;
            }
            this.log.info(String.format("Overriding existing file: %s", dest.toString()));
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format("Could not find checksum algorithm: %s", e.getLocalizedMessage()), e);
        }
    }

    @Override
    public void removeUnusedArtifactsFromLocal(Set<String> allResolvesFiles, Set<String> forDeletionFiles) throws IOException {
        for (String resolvedFile : forDeletionFiles) {
            File resolvedFileParent = FileUtils.getFile((String[])new String[]{resolvedFile}).getParentFile();
            File[] fileSiblings = resolvedFileParent.listFiles();
            if (fileSiblings == null || fileSiblings.length == 0) continue;
            for (File sibling : fileSiblings) {
                if (this.isResolvedOrParentOfResolvedFile(allResolvesFiles, sibling.getPath())) continue;
                this.log.info("Deleted unresolved file '" + sibling.getPath() + "'");
                sibling.delete();
            }
        }
    }

    @Override
    public void setFlatDownload(boolean flat) {
        this.flatDownload = flat;
    }

    private boolean isResolvedOrParentOfResolvedFile(Set<String> resolvedFiles, String path) {
        return CommonUtils.isAnySatisfying(resolvedFiles, filePath -> StringUtils.equals((CharSequence)filePath, (CharSequence)path) || StringUtils.startsWith((CharSequence)filePath, (CharSequence)path));
    }
}

