/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;

public class UrlUtils {
    private static final Pattern CREDENTIALS_IN_URL_REGEX = Pattern.compile("(http|https|git)://.+@");

    public static String removeCredentialsFromUrl(String lineWithCredentials) {
        Matcher matcher = CREDENTIALS_IN_URL_REGEX.matcher(lineWithCredentials);
        if (!matcher.find()) {
            return lineWithCredentials;
        }
        String credentialsPart = matcher.group();
        String protocol = matcher.group(1);
        return StringUtils.replace((String)lineWithCredentials, (String)credentialsPart, (String)(protocol + "://"));
    }

    public static void appendParamsToUrl(Map<String, String> requestParams, StringBuilder urlBuilder) {
        if (requestParams != null && !requestParams.isEmpty()) {
            urlBuilder.append("params=");
            Iterator<Map.Entry<String, String>> paramEntryIterator = requestParams.entrySet().iterator();
            String encodedPipe = JFrogService.encodeUrl("|");
            while (paramEntryIterator.hasNext()) {
                Map.Entry<String, String> paramEntry = paramEntryIterator.next();
                urlBuilder.append(JFrogService.encodeUrl(paramEntry.getKey()));
                String paramValue = paramEntry.getValue();
                if (StringUtils.isNotBlank((CharSequence)paramValue)) {
                    urlBuilder.append("=").append(JFrogService.encodeUrl(paramValue));
                }
                if (!paramEntryIterator.hasNext()) continue;
                urlBuilder.append(encodedPipe);
            }
        }
    }
}

