/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.extractor.clientConfiguration.client.VoidJFrogService;
import org.jfrog.build.extractor.clientConfiguration.util.DeploymentUrlUtils;

public class SetProperties
extends VoidJFrogService {
    public static final String SET_PROPERTIES_ENDPOINT = "api/storage/";
    private ArrayListMultimap<String, String> propertiesMap;
    private final boolean encodeProperties;
    private final String relativePath;
    private String propertiesString;

    private SetProperties(String relativePath, String propertiesString, ArrayListMultimap<String, String> propertiesMap, boolean encodeProperties, Log log) {
        super(log);
        this.relativePath = relativePath;
        this.propertiesMap = propertiesMap;
        this.propertiesString = propertiesString;
        this.encodeProperties = encodeProperties;
    }

    public SetProperties(String relativePath, String propertiesString, boolean encodeProperties, Log log) {
        this(relativePath, propertiesString, null, encodeProperties, log);
    }

    public SetProperties(String relativePath, ArrayListMultimap<String, String> propertiesMap, boolean encodeProperties, Log log) {
        this(relativePath, null, propertiesMap, encodeProperties, log);
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        String requestUrl = SET_PROPERTIES_ENDPOINT + SetProperties.encodeUrl(StringUtils.stripEnd((String)this.relativePath, (String)"/") + "?properties=");
        requestUrl = StringUtils.isNotEmpty((CharSequence)this.propertiesString) ? requestUrl + (this.encodeProperties ? DeploymentUrlUtils.buildMatrixParamsString(this.mapPropsString(this.propertiesString), true) : this.propertiesString) : requestUrl + DeploymentUrlUtils.buildMatrixParamsString(this.propertiesMap, this.encodeProperties);
        return new HttpPut(requestUrl);
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Failed to set properties to  '" + this.relativePath + "'");
        SetProperties.throwException(entity, this.getStatusCode());
    }

    @Override
    protected void ensureRequirements(JFrogHttpClient client) throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.propertiesString)) {
            return;
        }
        for (String prop : this.propertiesString.trim().split(";")) {
            if (prop.isEmpty()) continue;
            String key = StringUtils.substringBefore((String)prop, (String)"=");
            if (key.isEmpty()) {
                throw new IOException("Setting properties: Every property must have a key.");
            }
            String values = StringUtils.substringAfter((String)prop, (String)"=");
            if (!values.isEmpty() && StringUtils.countMatches((CharSequence)values, (CharSequence)",") != values.length()) continue;
            throw new IOException("Setting properties: Every property must have at least one value.");
        }
    }

    private ArrayListMultimap<String, String> mapPropsString(String props) {
        String[] propsList;
        ArrayListMultimap propsMap = ArrayListMultimap.create();
        for (String prop : propsList = props.split(";")) {
            if (!StringUtils.isNotEmpty((CharSequence)prop)) continue;
            String[] propParts = prop.split("=");
            propsMap.put((Object)propParts[0], (Object)propParts[1]);
        }
        return propsMap;
    }
}

