/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.scan.GeneralInfo;
import org.jfrog.build.extractor.scan.Issue;
import org.jfrog.build.extractor.scan.License;
import org.jfrog.build.extractor.scan.Scope;

@JsonFilter(value="xray-graph-filter")
public class DependencyTree
extends DefaultMutableTreeNode {
    private Set<License> violatedLicenses = new HashSet<License>();
    private Set<License> licenses = new HashSet<License>();
    private Set<Issue> issues = new HashSet<Issue>();
    private Set<Scope> scopes = new HashSet<Scope>();
    private Issue topIssue = new Issue();
    private GeneralInfo generalInfo;
    private String packagePrefix = "";
    private boolean metadata;

    public DependencyTree() {
    }

    public DependencyTree(Object userObject) {
        super(userObject);
    }

    public void setViolatedLicenses(Set<License> violatedLicenses) {
        this.violatedLicenses = violatedLicenses;
    }

    public Set<License> getViolatedLicenses() {
        return this.violatedLicenses;
    }

    public void setLicenses(Set<License> licenses) {
        this.licenses = licenses;
    }

    public void setIssues(Set<Issue> issues) {
        this.issues = issues;
    }

    @JsonProperty(value="component_id")
    public String getComponentId() {
        return this.packagePrefix + this;
    }

    public void setScopes(Set<Scope> scopes) {
        this.scopes = scopes;
    }

    public void setGeneralInfo(GeneralInfo generalInfo) {
        this.generalInfo = generalInfo;
    }

    public Set<License> getLicenses() {
        return this.licenses;
    }

    public Set<Issue> getIssues() {
        return this.issues;
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    public GeneralInfo getGeneralInfo() {
        return this.generalInfo;
    }

    public Issue getTopIssue() {
        return this.topIssue;
    }

    public boolean isMetadata() {
        return this.metadata;
    }

    public void setMetadata(boolean metadata) {
        this.metadata = metadata;
    }

    public void setPrefix(String prefix) {
        this.packagePrefix = prefix.toLowerCase() + "://";
        this.getChildren().forEach(node -> node.setPrefix(prefix));
    }

    public int getIssueCount() {
        return this.issues.size();
    }

    public Vector<DependencyTree> getChildren() {
        return this.children != null ? this.children : new Vector();
    }

    @JsonProperty(value="nodes")
    public List<DependencyTree> getNodes() {
        return this.children;
    }

    public Set<Issue> processTreeIssues() {
        this.setIssuesComponent();
        this.getChildren().forEach(child -> this.issues.addAll(child.processTreeIssues()));
        this.setTopIssue();
        this.sortChildren();
        return this.issues;
    }

    private void setIssuesComponent() {
        Object userObject = this.getUserObject();
        if (userObject != null) {
            this.issues.forEach(issue -> issue.setComponent(userObject.toString()));
        }
    }

    private void sortChildren() {
        this.getChildren().sort(Comparator.comparing(DependencyTree::getTopIssue, Comparator.comparing(Issue::getSeverity)).thenComparing(DependencyTree::getIssueCount).thenComparing(DefaultMutableTreeNode::getChildCount).reversed().thenComparing(DefaultMutableTreeNode::toString));
    }

    private void setTopIssue() {
        this.issues.forEach(issue -> {
            if (this.topIssue.isTopSeverity()) {
                return;
            }
            if (issue.isHigherSeverityThan(this.topIssue)) {
                this.topIssue = issue;
            }
        });
    }

    public Set<License> processTreeViolatedLicenses() {
        this.setViolatedLicensesComponent();
        this.violatedLicenses.addAll(this.licenses.stream().filter(License::isViolate).collect(Collectors.toSet()));
        this.getChildren().forEach(child -> this.violatedLicenses.addAll(child.processTreeViolatedLicenses()));
        return this.violatedLicenses;
    }

    private void setViolatedLicensesComponent() {
        Object userObject = this.getUserObject();
        if (userObject != null) {
            this.licenses.forEach(license -> license.setComponent(userObject.toString()));
        }
    }

    public void collectAllScopesAndLicenses(Set<Scope> allScopes, Set<License> allLicenses) {
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DependencyTree child = (DependencyTree)enumeration.nextElement();
            allScopes.addAll(child.getScopes());
            allLicenses.addAll(child.getLicenses());
        }
    }

    public DependencyTree find(String componentId) {
        if (StringUtils.equals((CharSequence)this.toString(), (CharSequence)componentId)) {
            return this;
        }
        return this.getChildren().stream().map(child -> child.find(componentId)).filter(Objects::nonNull).findAny().orElse(null);
    }

    public boolean hasLoop(Log logger) {
        for (DependencyTree parent = (DependencyTree)this.getParent(); parent != null; parent = (DependencyTree)parent.getParent()) {
            if (!Objects.equals(this.getUserObject(), parent.getUserObject())) continue;
            logger.debug("Loop detected in " + this.getUserObject());
            return true;
        }
        return false;
    }
}

