/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.packageManager;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.http.client.utils.URIBuilder;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.packageManager.PackageManagerLogger;

public class PackageManagerUtils {
    public static ArtifactoryClientConfiguration createArtifactoryClientConfiguration() {
        PackageManagerLogger log = new PackageManagerLogger();
        ArtifactoryClientConfiguration clientConfiguration = new ArtifactoryClientConfiguration(log);
        Properties allBuildProps = new Properties();
        allBuildProps.putAll(System.getenv());
        Properties allProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile(allBuildProps, log);
        clientConfiguration.fillFromProperties(allProps);
        return clientConfiguration;
    }

    public static String createArtifactoryUrlWithCredentials(String url, String username, String password, String path) throws MalformedURLException, URISyntaxException {
        URL rtUrl = new URL(url);
        URIBuilder proxyUrlBuilder = new URIBuilder().setScheme(rtUrl.getProtocol()).setUserInfo(username, password).setHost(rtUrl.getHost()).setPath(rtUrl.getPath() + path);
        return proxyUrlBuilder.build().toURL().toString();
    }

    public static void collectEnvIfNeeded(ArtifactoryClientConfiguration clientConfiguration, BuildInfo buildInfo) {
        if (!clientConfiguration.isIncludeEnvVars().booleanValue()) {
            return;
        }
        Properties envProperties = new Properties();
        envProperties.putAll(clientConfiguration.getAllProperties());
        envProperties = BuildInfoExtractorUtils.getEnvProperties(envProperties, clientConfiguration.getLog());
        if (buildInfo.getProperties() != null) {
            buildInfo.getProperties().putAll((Map<?, ?>)envProperties);
            return;
        }
        buildInfo.setProperties(envProperties);
    }
}

