/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.JFrogHttpClient;
import org.jfrog.build.client.artifactoryXrayResponse.ArtifactoryXrayResponse;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;

public class ScanBuild
extends JFrogService<ArtifactoryXrayResponse> {
    public static final int XRAY_SCAN_CONNECTION_TIMEOUT_SECS = 90;
    private static final String XRAY_FATAL_FAIL_STATUS = "-1";
    private static final int XRAY_SCAN_RETRY_CONSECUTIVE_RETRIES = 5;
    private static final int XRAY_SCAN_SLEEP_BETWEEN_RETRIES_MILLIS = 30000;
    private static final String SCAN_BUILD_URL = "api/xray/scanBuild";
    private final String buildName;
    private final String buildNumber;
    private final String project;
    private final String context;
    private HttpPost request;

    public ScanBuild(String buildName, String buildNumber, String project, String context, Log log) {
        super(log);
        this.buildName = buildName;
        this.buildNumber = buildNumber;
        this.project = project;
        this.context = context;
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        StringEntity entity = new StringEntity(this.getXrayScanBody());
        entity.setContentType("application/json");
        HttpPost request = new HttpPost(SCAN_BUILD_URL);
        request.addHeader("X-Accel-Buffering", "no");
        request.setEntity((HttpEntity)entity);
        this.request = request;
        return request;
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        JsonNode result;
        ObjectMapper mapper = new ObjectMapper();
        String content = IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name());
        try {
            result = mapper.readTree(content);
            if (result == null) {
                throw new NullPointerException("Received empty content from Artifactory");
            }
        }
        catch (Exception ex) {
            throw new XrayErrorException(String.format("Failed processing scan response: %s\n%s", ex, content));
        }
        if (result.get("errors") != null) {
            String resultStr = result.get("errors").toString();
            for (JsonNode error : result.get("errors")) {
                if (!error.get("status").toString().equals(XRAY_FATAL_FAIL_STATUS)) continue;
                throw new RuntimeException("Artifactory response: " + resultStr);
            }
            throw new XrayErrorException("Artifactory response: " + resultStr);
        }
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.result = mapper.treeToValue((TreeNode)result, ArtifactoryXrayResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactoryXrayResponse execute(JFrogHttpClient client) throws IOException {
        int retryNum = 0;
        long lastConnectionAttemptMillis = 0L;
        while (true) {
            try {
                lastConnectionAttemptMillis = System.currentTimeMillis();
                ++retryNum;
                ArtifactoryXrayResponse artifactoryXrayResponse = (ArtifactoryXrayResponse)super.execute(client);
                return artifactoryXrayResponse;
            }
            catch (XrayErrorException e) {
                this.handleException(retryNum, e);
                continue;
            }
            catch (IOException e) {
                if (this.isStableConnection(lastConnectionAttemptMillis)) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new IOException("Operation interrupted.");
                    }
                    retryNum = 0;
                    continue;
                }
                this.handleException(retryNum, e);
                continue;
            }
            finally {
                this.request.releaseConnection();
                continue;
            }
            break;
        }
    }

    private boolean isStableConnection(long lastConnectionAttemptMillis) {
        long stableConnectionMillis = 100000L;
        return lastConnectionAttemptMillis + 100000L < System.currentTimeMillis();
    }

    private void handleException(int retryNum, IOException e) throws IOException {
        if (5 <= retryNum) {
            throw e;
        }
        this.log.warn("Xray scan connection lost: " + e.getMessage() + ", attempting to reconnect...");
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private String getXrayScanBody() {
        String body = "{\"buildName\":\"" + this.buildName + "\",\"buildNumber\":\"" + this.buildNumber + "\",\"context\":\"" + this.context;
        if (StringUtils.isNotEmpty((CharSequence)this.project)) {
            body = body + "\",\"project\":\"" + this.project;
        }
        return body + "\"}";
    }

    private static class XrayErrorException
    extends IOException {
        private XrayErrorException(String message) {
            super(message);
        }
    }
}

