/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.executor;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.UrlUtils;
import org.jfrog.build.extractor.executor.CommandResults;

public class CommandExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TIMEOUT_EXIT_VALUE = 124;
    private static final int READER_SHUTDOWN_TIMEOUT_SECONDS = 30;
    private static final int PROCESS_TERMINATION_TIMEOUT_SECONDS = 30;
    private static final int EXECUTION_TIMEOUT_MINUTES = 120;
    private final Map<String, String> env;
    private final String executablePath;

    public CommandExecutor(String executablePath, Map<String, String> env) {
        this.executablePath = executablePath.trim();
        HashMap<String, String> finalEnvMap = new HashMap<String, String>(System.getenv());
        if (env != null) {
            HashMap<String, String> fixedEnvMap = new HashMap<String, String>(env);
            this.fixPathEnv(fixedEnvMap);
            finalEnvMap.putAll(fixedEnvMap);
        }
        this.env = new HashMap<String, String>(finalEnvMap);
    }

    private void fixPathEnv(Map<String, String> env) {
        String path = env.get("PATH");
        if (path == null) {
            return;
        }
        path = SystemUtils.IS_OS_WINDOWS ? CommandExecutor.getFixedWindowsPath(path) : path.replaceAll(";", File.pathSeparator) + ":/usr/local/bin";
        env.replace("PATH", path);
    }

    static String getFixedWindowsPath(String path) {
        String[] pathParts = path.split(";");
        CharSequence[] newPathParts = new String[pathParts.length];
        for (int index = 0; index < pathParts.length; ++index) {
            String part = pathParts[index];
            int backSlashIndex = part.indexOf(92);
            if (backSlashIndex < 0) {
                newPathParts[index] = part.replaceAll(":", ";");
                continue;
            }
            String startPart = part.substring(0, backSlashIndex);
            String endPart = part.substring(backSlashIndex);
            String newPart = startPart + endPart.replaceAll(":", ";");
            newPathParts[index] = newPart;
        }
        return String.join((CharSequence)";", newPathParts);
    }

    static String maskCredentials(String command, List<String> credentials) {
        if (credentials == null || credentials.isEmpty()) {
            return command;
        }
        String maskPattern = String.join((CharSequence)"|", credentials);
        return command.replaceAll(maskPattern, "***");
    }

    public CommandResults exeCommand(File execDir, List<String> args, List<String> credentials, Log logger) throws InterruptedException, IOException {
        return this.exeCommand(execDir, args, credentials, logger, 120L, TimeUnit.MINUTES);
    }

    /*
     * Exception decompiling
     */
    public CommandResults exeCommand(File execDir, List<String> args, List<String> credentials, Log logger, long timeout, TimeUnit unit) throws InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CommandResults getCommandResults(boolean terminatedProperly, List<String> args, String output, String error, int exitValue) {
        CommandResults commandRes = new CommandResults();
        if (!terminatedProperly) {
            error = error + System.lineSeparator() + String.format("Process '%s' had been terminated forcibly after timeout.", String.join((CharSequence)" ", args));
            exitValue = 124;
        }
        commandRes.setRes(output);
        commandRes.setErr(error);
        commandRes.setExitValue(exitValue);
        return commandRes;
    }

    private static Process runProcess(File execDir, String executablePath, List<String> args, List<String> credentials, Map<String, String> env, Log logger) throws IOException {
        HashMap newEnv = Maps.newHashMap(env);
        args = CommandExecutor.formatCommand(args, credentials, executablePath, newEnv);
        CommandExecutor.logCommand(logger, args, credentials);
        ProcessBuilder processBuilder = new ProcessBuilder(args).directory(execDir);
        processBuilder.environment().putAll(newEnv);
        return processBuilder.start();
    }

    private static List<String> formatCommand(List<String> args, List<String> credentials, String executablePath, Map<String, String> env) {
        if (credentials != null) {
            args.addAll(credentials);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            CommandExecutor.formatWindowsCommand(args, executablePath, env);
            return args;
        }
        return CommandExecutor.formatUnixCommand(args, executablePath);
    }

    private static void formatWindowsCommand(List<String> args, String executablePath, Map<String, String> env) {
        Path execPath = Paths.get(executablePath, new String[0]);
        if (execPath.isAbsolute()) {
            CommandExecutor.addToWindowsPath(env, execPath);
            args.add(0, execPath.getFileName().toString());
        } else {
            args.add(0, executablePath.replaceAll(" ", "^ "));
        }
        args.addAll(0, Arrays.asList("cmd", "/c"));
    }

    private static List<String> formatUnixCommand(List<String> args, String executablePath) {
        args.add(0, executablePath.replaceAll(" ", "\\\\ "));
        final String strArgs = String.join((CharSequence)" ", args);
        return new ArrayList<String>(){
            {
                this.add("/bin/sh");
                this.add("-c");
                this.add(strArgs);
            }
        };
    }

    static void addToWindowsPath(Map<String, String> env, Path execPath) {
        String execDirPath = execPath.getParent().toString();
        String windowsPathEnvKey = "Path";
        if (env.containsKey(windowsPathEnvKey)) {
            env.put(windowsPathEnvKey, execDirPath + File.pathSeparator + env.get(windowsPathEnvKey));
        } else {
            env.put(windowsPathEnvKey, execDirPath);
        }
    }

    private static void logCommand(Log logger, List<String> args, List<String> credentials) {
        if (logger == null) {
            return;
        }
        String output = UrlUtils.removeCredentialsFromUrl(String.join((CharSequence)" ", args));
        output = CommandExecutor.maskCredentials(output, credentials);
        logger.info("Executing command: " + output);
    }
}

