/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.deploy;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.BuildFileBean;
import org.jfrog.build.api.producerConsumer.ProducerConsumerItem;

public class DeployDetails
implements Comparable<DeployDetails>,
Serializable,
ProducerConsumerItem {
    String artifactPath;
    File file;
    String sha1;
    String md5;
    String sha256;
    private Boolean deploySucceeded;
    MultiValuedMap<String, String> properties;
    private String targetRepository;
    private boolean explode;
    private PackageType packageType;

    public String getTargetRepository() {
        return this.targetRepository;
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public File getFile() {
        return this.file;
    }

    public MultiValuedMap<String, String> getProperties() {
        return this.properties;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public void setArtifactPath(String artifactPath) {
        this.artifactPath = artifactPath;
    }

    public Boolean getDeploySucceeded() {
        return this.deploySucceeded;
    }

    public void setDeploySucceeded(Boolean deploySucceeded) {
        this.deploySucceeded = deploySucceeded;
    }

    public String getMd5() {
        return this.md5;
    }

    public boolean isExplode() {
        return this.explode;
    }

    public PackageType getPackageType() {
        return this.packageType;
    }

    @Override
    public int compareTo(DeployDetails that) {
        return this.artifactPath.compareTo(that.artifactPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeployDetails details = (DeployDetails)o;
        return this.artifactPath.equals(details.artifactPath) && this.targetRepository.equals(details.targetRepository);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.artifactPath);
        return 31 * result + Objects.hashCode(this.targetRepository);
    }

    public static class Builder {
        private DeployDetails deployDetails = new DeployDetails();

        public DeployDetails build() {
            if (this.deployDetails.file == null || !this.deployDetails.file.exists()) {
                throw new IllegalArgumentException("File not found: " + this.deployDetails.file);
            }
            if (StringUtils.isBlank((CharSequence)this.deployDetails.targetRepository)) {
                throw new IllegalArgumentException("Target repository cannot be empty");
            }
            if (StringUtils.isBlank((CharSequence)this.deployDetails.artifactPath)) {
                throw new IllegalArgumentException("Artifact path cannot be empty");
            }
            return this.deployDetails;
        }

        public Builder bean(BuildFileBean bean) {
            Properties beanProperties = bean.getProperties();
            if (beanProperties != null) {
                ListValuedMap multimap = MultiMapUtils.newListValuedHashMap();
                beanProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> Builder.lambda$bean$0((MultiValuedMap)multimap, arg_0, arg_1)));
                this.deployDetails.properties = multimap;
            }
            this.deployDetails.sha1 = bean.getSha1();
            this.deployDetails.md5 = bean.getMd5();
            return this;
        }

        public Builder file(File file) {
            this.deployDetails.file = file;
            return this;
        }

        public Builder targetRepository(String targetRepository) {
            this.deployDetails.targetRepository = targetRepository;
            return this;
        }

        public Builder artifactPath(String artifactPath) {
            this.deployDetails.artifactPath = artifactPath;
            return this;
        }

        public Builder sha256(String sha256) {
            this.deployDetails.sha256 = sha256;
            return this;
        }

        public Builder sha1(String sha1) {
            this.deployDetails.sha1 = sha1;
            return this;
        }

        public Builder md5(String md5) {
            this.deployDetails.md5 = md5;
            return this;
        }

        public Builder explode(boolean isExplodeArchive) {
            this.deployDetails.explode = isExplodeArchive;
            return this;
        }

        public Builder packageType(PackageType packageType) {
            this.deployDetails.packageType = packageType;
            return this;
        }

        public Builder addProperty(String key, String value) {
            if (this.deployDetails.properties == null) {
                this.deployDetails.properties = MultiMapUtils.newListValuedHashMap();
            }
            this.deployDetails.properties.put((Object)key, (Object)value);
            return this;
        }

        public Builder addProperties(Map<String, String> propertiesToAdd) {
            if (this.deployDetails.properties == null) {
                this.deployDetails.properties = MultiMapUtils.newListValuedHashMap();
            }
            this.deployDetails.properties.putAll(propertiesToAdd);
            return this;
        }

        public Builder addProperties(MultiValuedMap<String, String> propertiesToAdd) {
            if (this.deployDetails.properties == null) {
                this.deployDetails.properties = MultiMapUtils.newListValuedHashMap();
            }
            this.deployDetails.properties.putAll(propertiesToAdd);
            return this;
        }

        private static /* synthetic */ void lambda$bean$0(MultiValuedMap multimap, Object key, Object value) {
            multimap.put((Object)((String)key), (Object)((String)value));
        }
    }

    public static enum PackageType {
        GENERIC,
        MAVEN,
        ANT,
        IVY,
        GRADLE,
        GO,
        NPM;

    }
}

