/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util.encryption;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.util.encryption.EncryptionKeyPair;
import org.jfrog.build.extractor.clientConfiguration.util.encryption.Encryptor;

public class PropertyEncryptor {
    public static Properties decryptPropertiesFromFile(String filePath, EncryptionKeyPair keyPair) throws IOException, InvalidAlgorithmParameterException, IllegalBlockSizeException, NoSuchPaddingException, BadPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        if (!new File(filePath).exists()) {
            throw new IOException("File " + filePath + " does not exist");
        }
        return PropertyEncryptor.decryptProperties(FileUtils.readFileToByteArray((File)new File(filePath)), keyPair);
    }

    private static Properties decryptProperties(byte[] encryptedData, EncryptionKeyPair keyPair) throws IOException, InvalidAlgorithmParameterException, IllegalBlockSizeException, NoSuchPaddingException, BadPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        byte[] decryptedBytes = Encryptor.decrypt(encryptedData, keyPair);
        String decryptedString = new String(decryptedBytes, StandardCharsets.UTF_8);
        return PropertyEncryptor.stringToProperties(decryptedString);
    }

    public static EncryptionKeyPair encryptedPropertiesToStream(OutputStream os, Properties properties) throws IOException, InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        EncryptionKeyPair keyPair = new EncryptionKeyPair();
        os.write(Encryptor.encrypt(PropertyEncryptor.propertiesToString(properties).getBytes(StandardCharsets.UTF_8), keyPair));
        return keyPair;
    }

    private static Properties stringToProperties(String propertiesString) throws IOException {
        Properties properties = new Properties();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(propertiesString.getBytes(StandardCharsets.UTF_8));){
            properties.load(inputStream);
        }
        return properties;
    }

    private static String propertiesToString(Properties properties) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : properties.stringPropertyNames()) {
            stringBuilder.append(key).append("=").append(properties.getProperty(key)).append("\n");
        }
        return stringBuilder.toString();
    }
}

