/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.UrlUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.util.encryption.EncryptionKeyPair;
import org.jfrog.build.extractor.clientConfiguration.util.encryption.PropertyEncryptor;

public abstract class BuildInfoExtractorUtils {
    public static final String BUILD_BROWSE_PLATFORM_URL = "/ui/builds";
    public static final String BUILD_BROWSE_URL = "/webapp/builds";
    private static final String BUILD_REPO_PARAM_PATTERN = "?buildRepo=%s-build-info&projectKey=%s";
    private static final int ARTIFACT_TYPE_LENGTH_LIMIT = 64;
    public static final Predicate<Object> BUILD_INFO_PREDICATE = new PrefixPredicate("buildInfo.");
    public static final Predicate<Object> BUILD_INFO_PROP_PREDICATE = new PrefixPredicate("buildInfo.property.");
    public static final Predicate<Object> ENV_PREDICATE = new PrefixPredicate("buildInfo.env.");
    public static final Predicate<Object> CLIENT_PREDICATE = new PrefixPredicate("artifactory.");
    public static final Predicate<Object> MATRIX_PARAM_PREDICATE = new PrefixPredicate("deploy.");

    public static Properties mergePropertiesWithSystemAndPropertyFile(Properties existingProps, Log log) {
        Properties mergedProps = new Properties();
        mergedProps.putAll((Map<?, ?>)BuildInfoExtractorUtils.searchAdditionalPropertiesFile(mergedProps, log));
        mergedProps.putAll((Map<?, ?>)BuildInfoExtractorUtils.addSystemProperties(existingProps));
        return mergedProps;
    }

    private static Properties addSystemProperties(Properties existingProps) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)existingProps);
        props.putAll((Map<?, ?>)System.getProperties());
        return props;
    }

    private static Properties searchAdditionalPropertiesFile(Properties existingProps, Log log) {
        Properties props;
        block33: {
            props = new Properties();
            String propsFilePath = BuildInfoExtractorUtils.getAdditionalPropertiesFile(existingProps, log);
            if (StringUtils.isBlank((CharSequence)propsFilePath)) {
                log.debug("[buildinfo] BuildInfo properties file path is not found.");
                return props;
            }
            File propertiesFile = new File(propsFilePath);
            if (!propertiesFile.exists()) {
                log.debug("[buildinfo] BuildInfo properties file is not exists.");
                return props;
            }
            try {
                EncryptionKeyPair keyPair = new EncryptionKeyPair(BuildInfoExtractorUtils.getPropertiesFileEncryptionKey(), BuildInfoExtractorUtils.getPropertiesFileEncryptionKeyIv());
                if (!keyPair.isEmpty()) {
                    log.debug("[buildinfo] Found an encryption for buildInfo properties file for this build.");
                    props.putAll((Map<?, ?>)PropertyEncryptor.decryptPropertiesFromFile(propertiesFile.getPath(), keyPair));
                    break block33;
                }
                try (InputStream inputStream = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
                    props.load(inputStream);
                }
                catch (IllegalArgumentException e) {
                    log.warn("[buildinfo] Properties file contains malformed Unicode encoding. Attempting to load with UTF-8 encoding: " + e.getMessage());
                    try (BufferedReader reader = Files.newBufferedReader(propertiesFile.toPath(), StandardCharsets.UTF_8);){
                        props.load(reader);
                    }
                    catch (Exception fallbackException) {
                        log.error("[buildinfo] Failed to load properties file even with UTF-8 fallback: " + fallbackException.getMessage());
                    }
                }
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new RuntimeException("Unable to load build info properties from file: " + propertiesFile.getAbsolutePath(), e);
            }
        }
        return props;
    }

    public static Map<String, ?> filterStringEntries(Map<String, ?> map) {
        return CommonUtils.filterMapValues(map, value -> value instanceof String);
    }

    public static Properties filterDynamicProperties(Properties source, Predicate<Object> filter) {
        Properties properties = new Properties();
        if (source != null) {
            properties.putAll((Map<?, ?>)CommonUtils.filterMapKeys((Map)source, filter));
        }
        return properties;
    }

    public static Properties stripPrefixFromProperties(Properties source, String prefix) {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            String key = entry.getKey().toString();
            props.put(StringUtils.removeStart((String)key, (String)prefix), entry.getValue());
        }
        return props;
    }

    public static Properties getEnvProperties(Properties startProps, Log log) {
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(startProps.getProperty("buildInfoConfig.envVarsIncludePatterns"), startProps.getProperty("buildInfoConfig.envVarsExcludePatterns"));
        Properties props = new Properties();
        for (Map.Entry<Object, Object> startEntry : startProps.entrySet()) {
            if (!BuildInfoExtractorUtils.isBuildInfoProperty((String)startEntry.getKey())) continue;
            props.put(startEntry.getKey(), startEntry.getValue());
        }
        Map<String, String> envMap = System.getenv();
        for (Map.Entry entry : envMap.entrySet()) {
            String varKey = (String)entry.getKey();
            if (PatternMatcher.pathConflicts(varKey, patterns)) continue;
            props.put("buildInfo.env." + varKey, entry.getValue());
        }
        HashMap<Object, Object> sysProps = new HashMap<Object, Object>(System.getProperties());
        Map map = CommonUtils.entriesOnlyOnLeftMap(sysProps, System.getenv());
        for (Map.Entry entry : map.entrySet()) {
            String varKey = (String)entry.getKey();
            if (PatternMatcher.pathConflicts(varKey, patterns)) continue;
            props.put(varKey, entry.getValue());
        }
        props.putAll((Map<?, ?>)BuildInfoExtractorUtils.filterDynamicProperties(BuildInfoExtractorUtils.searchAdditionalPropertiesFile(startProps, log), ENV_PREDICATE));
        return props;
    }

    private static boolean isBuildInfoProperty(String propertyKey) {
        return StringUtils.startsWithAny((CharSequence)propertyKey, (CharSequence[])new CharSequence[]{"buildInfoConfig.envVarsExcludePatterns", "buildInfo.env.", "buildInfoConfig.envVarsIncludePatterns"});
    }

    private static JsonFactory createJsonFactory() {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        jsonFactory.setCodec((ObjectCodec)mapper);
        return jsonFactory;
    }

    /*
     * Exception decompiling
     */
    public static String buildInfoToJsonString(BuildInfo buildInfo) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static BuildInfo jsonStringToBuildInfo(String json) throws IOException {
        JsonFactory jsonFactory = BuildInfoExtractorUtils.createJsonFactory();
        try (JsonParser parser = jsonFactory.createParser((Reader)new StringReader(json));){
            BuildInfo buildInfo = (BuildInfo)jsonFactory.getCodec().readValue(parser, BuildInfo.class);
            return buildInfo;
        }
    }

    /*
     * Exception decompiling
     */
    public static <T extends Serializable> String buildInfoToJsonString(T buildComponent) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T extends Serializable> T jsonStringToGeneric(String json, Class<T> clazz) throws IOException {
        JsonFactory jsonFactory = BuildInfoExtractorUtils.createJsonFactory();
        try (JsonParser parser = jsonFactory.createParser((Reader)new StringReader(json));){
            Serializable serializable = (Serializable)jsonFactory.getCodec().readValue(parser, clazz);
            return (T)serializable;
        }
    }

    public static void saveBuildInfoToFile(BuildInfo buildInfo, File toFile) throws IOException {
        String buildInfoJson = BuildInfoExtractorUtils.buildInfoToJsonString(buildInfo);
        if (!toFile.getParentFile().exists()) {
            toFile.getParentFile().mkdirs();
        }
        if (!toFile.exists()) {
            toFile.createNewFile();
        }
        CommonUtils.writeByCharset((String)buildInfoJson, (File)toFile, (Charset)StandardCharsets.UTF_8);
    }

    private static String getPropertiesFileEncryptionKey() {
        return StringUtils.isNotBlank((CharSequence)System.getenv("PROPERTIES_FILE_KEY")) ? System.getenv("PROPERTIES_FILE_KEY") : System.getProperty("PROPERTIES_FILE_KEY");
    }

    private static String getPropertiesFileEncryptionKeyIv() {
        return StringUtils.isNotBlank((CharSequence)System.getenv("PROPERTIES_FILE_KEY_IV")) ? System.getenv("PROPERTIES_FILE_KEY_IV") : System.getProperty("PROPERTIES_FILE_KEY_IV");
    }

    private static String getAdditionalPropertiesFile(Properties additionalProps, Log log) {
        String key = "buildInfoConfig.propertiesFile";
        String filePath = System.getProperty(key);
        String propFoundPath = "System.getProperty(" + key + ")";
        if (StringUtils.isBlank((CharSequence)filePath)) {
            filePath = additionalProps.getProperty(key);
            propFoundPath = "additionalProps.getProperty(" + key + ")";
        }
        if (StringUtils.isBlank((CharSequence)filePath)) {
            filePath = additionalProps.getProperty("env." + key);
            if (StringUtils.isBlank((CharSequence)filePath)) {
                filePath = System.getenv(key);
                propFoundPath = "System.getenv(" + key + ")";
            } else {
                propFoundPath = "additionalProps.getProperty(env." + key + ")";
            }
        }
        if (StringUtils.isBlank((CharSequence)filePath)) {
            key = "BUILDINFO_PROPFILE";
            filePath = additionalProps.getProperty("env." + key);
            if (StringUtils.isBlank((CharSequence)filePath)) {
                filePath = System.getenv(key);
                propFoundPath = "System.getenv(" + key + ")";
            } else {
                propFoundPath = "additionalProps.getProperty(env." + key + ")";
            }
        }
        if (log != null) {
            if (StringUtils.isBlank((CharSequence)filePath)) {
                log.debug("[buildinfo] Not using buildInfo properties file for this build.");
            } else {
                log.debug("[buildinfo] Properties file '" + filePath + "' retrieved from '" + propFoundPath + "'");
            }
        }
        return filePath;
    }

    public static String getArtifactId(String moduleId, String artifactName) {
        return moduleId + ":" + artifactName;
    }

    public static String getTypeString(String type, String classifier, String extension) {
        String result = type;
        if ("jar".equals(type) && StringUtils.isNotBlank((CharSequence)classifier)) {
            result = classifier;
        }
        if (!("jar".equals(result) || "pom".equals(type) || "ivy".equals(type) || !StringUtils.isNotBlank((CharSequence)extension) || result.endsWith(extension))) {
            result = result + "-" + extension;
        }
        return result.length() > 64 ? type : result;
    }

    public static String getModuleIdString(String organisation, String name, String version) {
        return organisation + ':' + name + ':' + version;
    }

    public static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    private static void addPropsFromCommandSystemProp(Properties additionalProps, Log log) {
        String commandKey = "sun.java.command";
        String[] keys = new String[]{"buildInfoConfig.propertiesFile", "artifactory.publish.password"};
        String command = System.getProperty(commandKey);
        if (StringUtils.isNotBlank((CharSequence)command)) {
            String[] commandParts;
            for (String commandPart : commandParts = StringUtils.split((String)command, (String)" ")) {
                for (String key : keys) {
                    if (!commandPart.startsWith("-D" + key)) continue;
                    additionalProps.put(key, StringUtils.split((String)commandPart, (String)"=")[1].trim());
                    log.debug(String.format("Adding property %s from the command property: %s", key, commandKey));
                }
            }
        }
    }

    public static String createBuildInfoUrl(String url, String buildName, String buildNumber, String timeStamp, String project, boolean encode, boolean platformUrl) {
        if (platformUrl) {
            return BuildInfoExtractorUtils.createBuildInfoUrl(url, buildName, buildNumber, timeStamp, project, encode);
        }
        if (StringUtils.isNotBlank((CharSequence)project)) {
            if (StringUtils.endsWith((CharSequence)url, (CharSequence)"/artifactory")) {
                return BuildInfoExtractorUtils.createBuildInfoUrl(StringUtils.removeEnd((String)url, (String)"/artifactory"), buildName, buildNumber, timeStamp, project, encode);
            }
            return "";
        }
        return BuildInfoExtractorUtils.createBuildInfoUrl(url, buildName, buildNumber, encode);
    }

    private static String createBuildInfoUrl(String platformUrl, String buildName, String buildNumber, String timeStamp, String project, boolean encode) {
        if (encode) {
            buildName = UrlUtils.encodeUrlPathPart(buildName);
            buildNumber = UrlUtils.encodeUrlPathPart(buildNumber);
        }
        String timestampUrlPart = StringUtils.isBlank((CharSequence)timeStamp) ? "" : "/" + timeStamp;
        return String.format("%s/%s/%s%s/%s", platformUrl + BUILD_BROWSE_PLATFORM_URL, buildName, buildNumber, timestampUrlPart, "published" + BuildInfoExtractorUtils.getBuildRepoQueryParam(project));
    }

    private static String getBuildRepoQueryParam(String project) {
        if (StringUtils.isEmpty((CharSequence)project)) {
            return "";
        }
        String encodedProject = UrlUtils.encodeUrl(project);
        return String.format(BUILD_REPO_PARAM_PATTERN, encodedProject, encodedProject);
    }

    private static String createBuildInfoUrl(String artifactoryUrl, String buildName, String buildNumber, boolean encode) {
        if (encode) {
            buildName = UrlUtils.encodeUrlPathPart(buildName);
            buildNumber = UrlUtils.encodeUrlPathPart(buildNumber);
        }
        return String.format("%s/%s/%s", artifactoryUrl + BUILD_BROWSE_URL, buildName, buildNumber);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static class PrefixPredicate
    implements Predicate<Object> {
        private String prefix;

        protected PrefixPredicate(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean test(Object o) {
            return o != null && ((String)o).startsWith(this.prefix);
        }
    }
}

