/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.filespecs.aql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jfrog.filespecs.aql.RepoPathFile;

public class PatternParsingUtils {
    static List<RepoPathFile> createRepoPathFileTriples(String searchPattern, boolean recursive) {
        int firstSlashIndex = searchPattern.indexOf("/");
        ArrayList<Integer> asteriskIndices = new ArrayList<Integer>();
        for (int i = 0; i < searchPattern.length(); ++i) {
            if (searchPattern.charAt(i) != '*') continue;
            asteriskIndices.add(i);
        }
        if (!asteriskIndices.isEmpty() && !PatternParsingUtils.isSlashPrecedeAsterisk((Integer)asteriskIndices.get(0), firstSlashIndex)) {
            int asteriskIndex;
            ArrayList<RepoPathFile> triples = new ArrayList<RepoPathFile>();
            int lastRepoAsteriskIndex = 0;
            Iterator iterator = asteriskIndices.iterator();
            while (iterator.hasNext() && !PatternParsingUtils.isSlashPrecedeAsterisk(asteriskIndex = ((Integer)iterator.next()).intValue(), firstSlashIndex)) {
                String repo = searchPattern.substring(0, asteriskIndex + 1);
                String newPattern = searchPattern.substring(asteriskIndex);
                int slashCount = StringUtils.countMatches((String)newPattern, (String)"/");
                int asterixCount = StringUtils.countMatches((String)newPattern, (String)"*");
                if (!(slashCount <= 1 && asterixCount <= 1 || (newPattern = newPattern.replaceFirst("^\\*/", "")).startsWith("*"))) {
                    newPattern = "*" + newPattern;
                }
                triples.addAll(PatternParsingUtils.createPathFilePairs(repo, newPattern, recursive));
                lastRepoAsteriskIndex = asteriskIndex + 1;
            }
            if (lastRepoAsteriskIndex < firstSlashIndex) {
                String repo = searchPattern.substring(0, firstSlashIndex);
                String newPattern = searchPattern.substring(firstSlashIndex + 1);
                triples.addAll(PatternParsingUtils.createPathFilePairs(repo, newPattern, recursive));
            } else if (firstSlashIndex < 0 && !StringUtils.endsWith((String)searchPattern, (String)"*")) {
                triples.addAll(PatternParsingUtils.createPathFilePairs(searchPattern, "*", recursive));
            }
            return triples;
        }
        if (firstSlashIndex < 0) {
            return PatternParsingUtils.createPathFilePairs(searchPattern, "*", recursive);
        }
        String repo = searchPattern.substring(0, firstSlashIndex);
        String pattern = searchPattern.substring(firstSlashIndex + 1);
        return PatternParsingUtils.createPathFilePairs(repo, pattern, recursive);
    }

    private static boolean isSlashPrecedeAsterisk(int asteriskIndex, int slashIndex) {
        return slashIndex < asteriskIndex && slashIndex >= 0;
    }

    static List<RepoPathFile> createPathFilePairs(String repo, String pattern, boolean recursive) {
        String name;
        String path;
        ArrayList<RepoPathFile> res = new ArrayList<RepoPathFile>();
        if (pattern.equals("*")) {
            res.add(new RepoPathFile(repo, PatternParsingUtils.getDefaultPath(recursive), "*"));
            return res;
        }
        ArrayList<RepoPathFile> triples = new ArrayList<RepoPathFile>();
        int slashIndex = pattern.lastIndexOf("/");
        if (slashIndex < 0) {
            if (recursive && pattern.startsWith("*")) {
                path = "";
                name = pattern;
            } else {
                path = "";
                name = pattern;
                triples.add(new RepoPathFile(repo, ".", pattern));
            }
        } else {
            path = pattern.substring(0, slashIndex);
            name = pattern.substring(slashIndex + 1);
            triples.add(new RepoPathFile(repo, path, name));
        }
        if (!recursive) {
            return triples;
        }
        if (name.equals("*")) {
            triples.add(new RepoPathFile(repo, path + "/*", "*"));
            return triples;
        }
        PatternParsingUtils.populateTriplesWithRepoPathFile(triples, repo, path, name);
        return triples;
    }

    private static String getDefaultPath(boolean recursive) {
        if (recursive) {
            return "*";
        }
        return ".";
    }

    private static void populateTriplesWithRepoPathFile(List<RepoPathFile> triples, String repo, String path, String name) {
        String[] nameSplit = name.split("\\*", -1);
        for (int i = 0; i < nameSplit.length - 1; ++i) {
            String str = "";
            for (int j = 0; j < nameSplit.length; ++j) {
                String namePart = nameSplit[j];
                if (j > 0) {
                    str = str + "*";
                }
                str = j == i ? str + nameSplit[i] + "*/" : str + namePart;
            }
            String[] slashSplit = str.split("/", -1);
            String filePath = slashSplit[0];
            String fileName = slashSplit[1];
            if (fileName.equals("")) {
                fileName = "*";
            }
            if (!path.equals("") && !path.endsWith("/")) {
                path = path + "/";
            }
            triples.add(new RepoPathFile(repo, path + filePath, fileName));
        }
    }
}

