/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.maven.annomojo.extractor;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.descriptor.DuplicateParameterException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.Requirement;
import org.codehaus.plexus.util.StringUtils;
import org.jfrog.maven.annomojo.annotations.MojoAggregator;
import org.jfrog.maven.annomojo.annotations.MojoAnnotation;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoConfigurator;
import org.jfrog.maven.annomojo.annotations.MojoExecute;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoInheritedByDefault;
import org.jfrog.maven.annomojo.annotations.MojoInstantiationStrategy;
import org.jfrog.maven.annomojo.annotations.MojoMultiExecution;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDirectInvocation;
import org.jfrog.maven.annomojo.annotations.MojoRequiresOnline;
import org.jfrog.maven.annomojo.annotations.MojoRequiresProject;
import org.jfrog.maven.annomojo.extractor.MojoDescriptorTls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MojoApf
implements AnnotationProcessorFactory {
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList(MojoAnnotation.class.getPackage().getName() + ".*"));
    private static final Collection<String> supportedOptions = Collections.emptySet();
    private final PluginDescriptor descriptor;

    public MojoApf(PluginDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        return new MojoAp(env);
    }

    private class MojoAp
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;

        MojoAp(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        public void process() {
            Collection declarations = this.env.getSpecifiedTypeDeclarations();
            for (TypeDeclaration typeDecl : declarations) {
                try {
                    typeDecl.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new MojoClassVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private class MojoClassVisitor
        extends SimpleDeclarationVisitor {
            private MojoDescriptor mojoDescriptor;
            private Set<Declaration> visitedDeclarations = new HashSet<Declaration>();

            private MojoClassVisitor() {
            }

            public void visitClassDeclaration(ClassDeclaration d) {
                MojoPhase phase;
                ClassType superclass;
                if (this.checkVisited((Declaration)d)) {
                    return;
                }
                boolean isAbstract = d.getModifiers().contains(Modifier.ABSTRACT);
                if (isAbstract && this.mojoDescriptor == null) {
                    return;
                }
                MojoGoal goal = (MojoGoal)d.getAnnotation(MojoGoal.class);
                if (goal == null && this.mojoDescriptor == null) {
                    return;
                }
                if (this.mojoDescriptor == null) {
                    this.mojoDescriptor = new MojoDescriptor();
                    this.mojoDescriptor.setPluginDescriptor(MojoApf.this.descriptor);
                    this.mojoDescriptor.setLanguage("java");
                    this.mojoDescriptor.setImplementation(d.getQualifiedName());
                    this.mojoDescriptor.setDescription(d.getDocComment());
                    this.mojoDescriptor.setGoal(goal.value());
                    MojoDescriptorTls.addDescriptor(this.mojoDescriptor);
                }
                if (this.shouldProcessClass(superclass = d.getSuperclass())) {
                    this.visitClassDeclaration(superclass.getDeclaration());
                }
                Collection superinterfaces = d.getSuperinterfaces();
                for (InterfaceType superinterface : superinterfaces) {
                    this.visitInterfaceDeclaration(superinterface.getDeclaration());
                }
                if (this.mojoDescriptor != null) {
                    this.processTypeMetadata((Declaration)d);
                }
                if ((phase = (MojoPhase)d.getAnnotation(MojoPhase.class)) != null) {
                    this.mojoDescriptor.setPhase(phase.value());
                }
                d.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)this, (DeclarationVisitor)DeclarationVisitors.NO_OP));
            }

            public void visitInterfaceDeclaration(InterfaceDeclaration d) {
                if (this.checkVisited((Declaration)d) || this.mojoDescriptor == null) {
                    return;
                }
                Collection superinterfaces = d.getSuperinterfaces();
                for (InterfaceType superinterface : superinterfaces) {
                    this.visitInterfaceDeclaration(superinterface.getDeclaration());
                }
                this.processTypeMetadata((Declaration)d);
                d.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)this, (DeclarationVisitor)DeclarationVisitors.NO_OP));
            }

            public void visitMethodDeclaration(MethodDeclaration d) {
                if (this.checkVisited((Declaration)d) || this.mojoDescriptor == null) {
                    return;
                }
                String methodName = d.getSimpleName();
                if (methodName.startsWith("get")) {
                    Parameter pd = new Parameter();
                    String propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                    String propertyType = d.getReturnType().toString();
                    this.processPropertyMetadata((MemberDeclaration)d, pd, propertyType, propertyName);
                }
                d.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)this, (DeclarationVisitor)DeclarationVisitors.NO_OP));
            }

            public void visitFieldDeclaration(FieldDeclaration d) {
                if (this.checkVisited((Declaration)d) || this.mojoDescriptor == null) {
                    return;
                }
                String propertyName = d.getSimpleName();
                String propertyType = d.getType().toString();
                Parameter pd = new Parameter();
                this.processPropertyMetadata((MemberDeclaration)d, pd, propertyType, propertyName);
                d.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)this, (DeclarationVisitor)DeclarationVisitors.NO_OP));
            }

            private void processTypeMetadata(Declaration d) {
                MojoInheritedByDefault inheritedByDefault;
                MojoRequiresOnline requiresOnline;
                MojoRequiresDirectInvocation requiresDirectInvocation;
                MojoAggregator aggregator;
                MojoRequiresProject requiresProject;
                MojoRequiresDependencyResolution requiresDependencyResolution;
                MojoExecute execute;
                MojoMultiExecution multiExecution;
                MojoInstantiationStrategy instantiationStrategy = (MojoInstantiationStrategy)d.getAnnotation(MojoInstantiationStrategy.class);
                if (instantiationStrategy != null) {
                    this.mojoDescriptor.setInstantiationStrategy(instantiationStrategy.value());
                }
                if ((multiExecution = (MojoMultiExecution)d.getAnnotation(MojoMultiExecution.class)) != null) {
                    this.mojoDescriptor.setExecutionStrategy("always");
                } else {
                    this.mojoDescriptor.setExecutionStrategy("once-per-session");
                }
                MojoConfigurator configurator = (MojoConfigurator)d.getAnnotation(MojoConfigurator.class);
                if (instantiationStrategy != null) {
                    this.mojoDescriptor.setComponentConfigurator(configurator.value());
                }
                if ((execute = (MojoExecute)d.getAnnotation(MojoExecute.class)) != null) {
                    String executePhase = execute.phase();
                    String executeGoal = execute.goal();
                    String lifecycle = execute.lifecycle();
                    if (executePhase.length() == 0) {
                        executePhase = null;
                    }
                    if (executeGoal.length() == 0) {
                        executeGoal = null;
                    }
                    if (lifecycle.length() == 0) {
                        lifecycle = null;
                    }
                    if (executePhase == null && executeGoal == null) {
                        throw new IllegalArgumentException("Eexecute tag requires a 'phase' or 'goal' parameter");
                    }
                    if (executePhase != null && executeGoal != null) {
                        throw new IllegalArgumentException("@Execute tag can have only one of a 'phase' or 'goal' parameter");
                    }
                    this.mojoDescriptor.setExecutePhase(executePhase);
                    this.mojoDescriptor.setExecuteGoal(executeGoal);
                    if (lifecycle != null) {
                        this.mojoDescriptor.setExecuteLifecycle(lifecycle);
                        if (executeGoal != null) {
                            throw new IllegalArgumentException("@Execute lifecycle requires a phase instead of a goal");
                        }
                    }
                }
                if ((requiresDependencyResolution = (MojoRequiresDependencyResolution)d.getAnnotation(MojoRequiresDependencyResolution.class)) != null) {
                    String value = requiresDependencyResolution.value();
                    this.mojoDescriptor.setDependencyResolutionRequired(value);
                }
                if ((requiresProject = (MojoRequiresProject)d.getAnnotation(MojoRequiresProject.class)) != null) {
                    this.mojoDescriptor.setProjectRequired(requiresProject.value());
                }
                if ((aggregator = (MojoAggregator)d.getAnnotation(MojoAggregator.class)) != null) {
                    this.mojoDescriptor.setAggregator(aggregator.value());
                }
                if ((requiresDirectInvocation = (MojoRequiresDirectInvocation)d.getAnnotation(MojoRequiresDirectInvocation.class)) != null) {
                    this.mojoDescriptor.setDirectInvocationOnly(requiresDirectInvocation.value());
                }
                if ((requiresOnline = (MojoRequiresOnline)d.getAnnotation(MojoRequiresOnline.class)) != null) {
                    this.mojoDescriptor.setOnlineRequired(requiresOnline.value());
                }
                if ((inheritedByDefault = (MojoInheritedByDefault)d.getAnnotation(MojoInheritedByDefault.class)) != null) {
                    this.mojoDescriptor.setInheritedByDefault(inheritedByDefault.value());
                }
            }

            private void processPropertyMetadata(MemberDeclaration d, Parameter pd, String propertyType, String propertyName) {
                String description;
                MojoParameter parameter = (MojoParameter)d.getAnnotation(MojoParameter.class);
                MojoComponent component = (MojoComponent)d.getAnnotation(MojoComponent.class);
                if (parameter == null && component == null) {
                    return;
                }
                pd.setName(propertyName);
                pd.setType(propertyType);
                if (component != null) {
                    String roleHint;
                    description = component.description();
                    if (StringUtils.isEmpty((String)description)) {
                        description = d.getDocComment();
                    }
                    pd.setDescription(description);
                    String role = component.role();
                    if (role.length() == 0) {
                        role = propertyType;
                    }
                    if ((roleHint = component.roleHint()).length() == 0) {
                        roleHint = null;
                    }
                    pd.setRequirement(new Requirement(role, roleHint));
                    pd.setName(propertyName);
                } else {
                    String defaultValue;
                    String expression;
                    String alias;
                    description = parameter.description();
                    if (StringUtils.isEmpty((String)description)) {
                        description = d.getDocComment();
                    }
                    pd.setDescription(description);
                    String property = parameter.property();
                    if (!StringUtils.isEmpty((String)property)) {
                        pd.setName(property);
                    } else {
                        pd.setName(propertyName);
                    }
                    pd.setRequired(parameter.required());
                    pd.setEditable(!parameter.readonly());
                    String deprecated = parameter.deprecated();
                    if (!StringUtils.isEmpty((String)deprecated)) {
                        pd.setDeprecated(deprecated);
                    }
                    if (!StringUtils.isEmpty((String)(alias = parameter.alias()))) {
                        pd.setAlias(alias);
                    }
                    if (StringUtils.isEmpty((String)(expression = parameter.expression()))) {
                        expression = null;
                    }
                    pd.setExpression(expression);
                    if ("${reports}".equals(pd.getExpression())) {
                        this.mojoDescriptor.setRequiresReports(true);
                    }
                    if (!StringUtils.isEmpty((String)(defaultValue = parameter.defaultValue()))) {
                        pd.setDefaultValue(defaultValue);
                    }
                }
                try {
                    List params = this.mojoDescriptor.getParameters();
                    if (params != null && params.contains(pd)) {
                        params.remove(pd);
                    }
                    this.mojoDescriptor.addParameter(pd);
                }
                catch (DuplicateParameterException e) {
                    throw new IllegalArgumentException("DuplicateParameter parameter: " + propertyName);
                }
            }

            private boolean isMojo(TypeDeclaration d) {
                ClassType superclass;
                Collection superinterfaces = d.getSuperinterfaces();
                for (InterfaceType superinterface : superinterfaces) {
                    if (superinterface.getDeclaration().getQualifiedName().equals("org.apache.maven.plugin.Mojo")) {
                        return true;
                    }
                    if (!this.isMojo((TypeDeclaration)superinterface.getDeclaration())) continue;
                    return true;
                }
                return d instanceof ClassDeclaration && this.shouldProcessClass(superclass = ((ClassDeclaration)d).getSuperclass()) && this.isMojo((TypeDeclaration)superclass.getDeclaration());
            }

            private boolean shouldProcessClass(ClassType superclass) {
                return superclass != null && !superclass.getDeclaration().getQualifiedName().equals("java.lang.Object");
            }

            private boolean checkVisited(Declaration d) {
                if (this.visitedDeclarations.contains(d)) {
                    return true;
                }
                if (this.mojoDescriptor != null) {
                    this.visitedDeclarations.add(d);
                }
                return false;
            }
        }
    }
}

