/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import jfxtras.scene.control.agenda.Agenda;

public class AllAppointments {
    private final ObservableList<Agenda.Appointment> appointments;
    private final ListChangeListener<Agenda.Appointment> listChangeListener = new ListChangeListener<Agenda.Appointment>(){

        public void onChanged(ListChangeListener.Change<? extends Agenda.Appointment> changes) {
            AllAppointments.this.fireOnChangeListener();
        }
    };
    private List<Runnable> runnables = new ArrayList<Runnable>();

    public AllAppointments(ObservableList<Agenda.Appointment> appointments) {
        this.appointments = appointments;
        appointments.addListener((ListChangeListener)new WeakListChangeListener(this.listChangeListener));
    }

    public void addOnChangeListener(Runnable runnable) {
        this.runnables.add(runnable);
    }

    public void removeOnChangeListener(Runnable runnable) {
        this.runnables.remove(runnable);
    }

    private void fireOnChangeListener() {
        for (Runnable runnable : this.runnables) {
            runnable.run();
        }
    }

    public List<Agenda.Appointment> collectWholedayFor(LocalDate localDate) {
        ArrayList<Agenda.Appointment> collectedAppointments = new ArrayList<Agenda.Appointment>();
        for (Agenda.Appointment lAppointment : this.appointments) {
            LocalDate endLocalDate;
            if (!lAppointment.isWholeDay().booleanValue()) continue;
            LocalDate startLocalDate = lAppointment.getStartLocalDateTime().toLocalDate();
            LocalDate localDate2 = endLocalDate = lAppointment.getEndLocalDateTime() == null ? startLocalDate : lAppointment.getEndLocalDateTime().minusNanos(1L).toLocalDate();
            if (!startLocalDate.isEqual(localDate) && !startLocalDate.isBefore(localDate) || !endLocalDate.isEqual(localDate) && !endLocalDate.isAfter(localDate)) continue;
            collectedAppointments.add(lAppointment);
        }
        return collectedAppointments;
    }

    public List<Agenda.Appointment> collectTaskFor(LocalDate localDate) {
        ArrayList<Agenda.Appointment> collectedAppointments = new ArrayList<Agenda.Appointment>();
        for (Agenda.Appointment lAppointment : this.appointments) {
            if (lAppointment.isWholeDay().booleanValue() || lAppointment.getEndLocalDateTime() != null || !lAppointment.getStartLocalDateTime().toLocalDate().isEqual(localDate)) continue;
            collectedAppointments.add(lAppointment);
        }
        return collectedAppointments;
    }

    public List<Agenda.Appointment> collectRegularFor(LocalDate localDate) {
        ArrayList<Agenda.Appointment> collectedAppointments = new ArrayList<Agenda.Appointment>();
        for (Agenda.Appointment lAppointment : this.appointments) {
            if (lAppointment.isWholeDay().booleanValue() || lAppointment.getEndLocalDateTime() == null) continue;
            LocalDate startLocalDate = lAppointment.getStartLocalDateTime().toLocalDate();
            LocalDate endLocalDate = lAppointment.getEndLocalDateTime().minusNanos(1L).toLocalDate();
            if (!startLocalDate.isEqual(localDate) && !startLocalDate.isBefore(localDate) || !endLocalDate.isEqual(localDate) && !endLocalDate.isAfter(localDate)) continue;
            collectedAppointments.add(lAppointment);
        }
        return collectedAppointments;
    }
}

