/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.temporal.Temporal;
import java.util.Calendar;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractPane$$Lambda$1;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractPane$$Lambda$2;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractPane$$Lambda$3;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu;
import jfxtras.internal.scene.control.skin.agenda.base24hour.HistoricalVisualizer;
import jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import jfxtras.scene.control.agenda.Agenda;
import jfxtras.scene.control.agenda.Agenda$Appointment$;
import jfxtras.util.NodeUtil;

abstract class AppointmentAbstractPane
extends Pane {
    protected final Agenda.Appointment appointment;
    protected final LayoutHelp layoutHelp;
    protected final HistoricalVisualizer historyVisualizer;
    protected final AppointmentMenu appointmentMenu;
    private final ListChangeListener<Agenda.Appointment> listChangeListener = new ListChangeListener<Agenda.Appointment>(){

        public void onChanged(ListChangeListener.Change<? extends Agenda.Appointment> changes) {
            AppointmentAbstractPane.this.setOrRemoveSelected();
        }
    };
    private static final String SELECTED = "Selected";
    private boolean dragging = false;
    private Rectangle dragRectangle = null;
    private double startX = 0.0;
    private double startY = 0.0;
    private LocalDateTime dragPickupDateTime;
    private boolean mouseActuallyHasDragged = false;
    private final int roundToMinutes = 5;
    private Text startTimeText = null;
    private Text endTimeText = null;
    private Agenda.Appointment appointmentForDrag = null;
    static final int DRAG_DAY = 1;
    static final int DRAG_DAYHEADER = 0;

    AppointmentAbstractPane(Agenda.Appointment appointment, LayoutHelp layoutHelp) {
        this.appointment = appointment;
        this.layoutHelp = layoutHelp;
        this.appointmentMenu = new AppointmentMenu(this, appointment, layoutHelp);
        this.getStyleClass().add((Object)"Appointment");
        this.getStyleClass().add((Object)(appointment.getAppointmentGroup() != null ? appointment.getAppointmentGroup().getStyleClass() : "group0"));
        this.historyVisualizer = new HistoricalVisualizer(this);
        this.getChildren().add((Object)this.historyVisualizer);
        if (appointment.getSummary() != null) {
            Tooltip.install((Node)this, (Tooltip)new Tooltip(appointment.getSummary()));
        }
        this.setupDragging();
        layoutHelp.skinnable.selectedAppointments().addListener((ListChangeListener)new WeakListChangeListener(this.listChangeListener));
    }

    private void setOrRemoveSelected() {
        if (this.getStyleClass().contains((Object)SELECTED) && !this.layoutHelp.skinnable.selectedAppointments().contains((Object)this.appointment)) {
            this.getStyleClass().remove((Object)SELECTED);
        }
        if (!this.getStyleClass().contains((Object)SELECTED) && this.layoutHelp.skinnable.selectedAppointments().contains((Object)this.appointment)) {
            this.getStyleClass().add((Object)SELECTED);
        }
    }

    void determineHistoryVisualizer(LocalDateTime now) {
        this.historyVisualizer.setVisible(this.appointment.getStartLocalDateTime().isBefore(now));
    }

    private void setupDragging() {
        this.setOnMousePressed(AppointmentAbstractPane$$Lambda$1.lambdaFactory$(this));
        this.setOnMouseDragged(AppointmentAbstractPane$$Lambda$2.lambdaFactory$(this));
        this.setOnMouseReleased(AppointmentAbstractPane$$Lambda$3.lambdaFactory$(this));
    }

    protected boolean showStartTimeText() {
        return true;
    }

    protected boolean showEndTimeText() {
        return true;
    }

    private void handleDrag(Agenda.Appointment appointment, LocalDateTime dragPickupDateTime, LocalDateTime dragDropDateTime) {
        boolean dragPickupInDayBody = this.dragInDayBody(dragPickupDateTime);
        boolean dragPickupInDayHeader = this.dragInDayHeader(dragPickupDateTime);
        dragPickupDateTime = this.layoutHelp.roundTimeToNearestMinutes(dragPickupDateTime, 5);
        boolean dragDropInDayBody = this.dragInDayBody(dragDropDateTime);
        boolean dragDropInDayHeader = this.dragInDayHeader(dragDropDateTime);
        dragDropDateTime = this.layoutHelp.roundTimeToNearestMinutes(dragDropDateTime, 5);
        if (dragPickupInDayBody && dragDropInDayBody || dragPickupInDayHeader && dragDropInDayHeader) {
            boolean changed = false;
            Duration duration = Duration.between(dragPickupDateTime, dragDropDateTime);
            if (appointment.getStartLocalDateTime() != null) {
                appointment.setStartLocalDateTime(appointment.getStartLocalDateTime().plus(duration));
                changed = true;
            }
            if (appointment.getEndLocalDateTime() != null) {
                appointment.setEndLocalDateTime(appointment.getEndLocalDateTime().plus(duration));
                changed = true;
            }
            if (changed) {
                this.layoutHelp.callAppointmentChangedCallback(appointment);
            }
        } else if (dragPickupInDayBody && dragDropInDayHeader) {
            appointment.setWholeDay(true);
            boolean changed = false;
            Period period = Period.between(dragPickupDateTime.toLocalDate(), dragDropDateTime.toLocalDate());
            if (appointment.getStartLocalDateTime() != null) {
                appointment.setStartLocalDateTime(appointment.getStartLocalDateTime().plus(period));
                changed = true;
            }
            if (appointment.getEndLocalDateTime() != null) {
                appointment.setEndLocalDateTime(appointment.getEndLocalDateTime().plus(period));
                changed = true;
            }
            if (changed) {
                this.layoutHelp.callAppointmentChangedCallback(appointment);
            }
        } else if (dragPickupInDayHeader && dragDropInDayBody) {
            appointment.setWholeDay(false);
            boolean changed = false;
            if (appointment.getStartLocalDateTime() != null && appointment.getEndLocalDateTime() == null) {
                appointment.setStartLocalDateTime(dragDropDateTime);
                changed = true;
            } else {
                appointment.setStartLocalDateTime(dragDropDateTime);
                appointment.setEndLocalDateTime(dragDropDateTime.plusHours(1L));
                changed = true;
            }
            if (changed) {
                this.layoutHelp.callAppointmentChangedCallback(appointment);
            }
        }
    }

    private void handleSelect(MouseEvent mouseEvent) {
        if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
            this.layoutHelp.skinnable.selectedAppointments().clear();
        }
        if (!this.layoutHelp.skinnable.selectedAppointments().contains((Object)this.appointment)) {
            this.layoutHelp.skinnable.selectedAppointments().add((Object)this.appointment);
        } else if (mouseEvent.isControlDown()) {
            this.layoutHelp.skinnable.selectedAppointments().remove((Object)this.appointment);
        }
    }

    private void handleAction() {
        Callback<Agenda.Appointment, Void> lCallback = this.layoutHelp.skinnable.getActionCallback();
        if (lCallback != null) {
            lCallback.call((Object)this.appointment);
            return;
        }
    }

    private boolean dragInDayBody(LocalDateTime localDateTime) {
        return localDateTime.getNano() == 1;
    }

    private boolean dragInDayHeader(LocalDateTime localDateTime) {
        return localDateTime.getNano() == 0;
    }

    public String toString() {
        return "appointment=" + this.appointment.getStartLocalDateTime() + "-" + this.appointment.getEndLocalDateTime() + ";" + "sumary=" + this.appointment.getSummary();
    }

    private /* synthetic */ void lambda$setupDragging$10(MouseEvent mouseEvent) {
        if (!this.dragging) {
            return;
        }
        mouseEvent.consume();
        this.dragging = false;
        this.setCursor(Cursor.HAND);
        if (this.dragRectangle != null) {
            this.layoutHelp.dragPane.getChildren().remove((Object)this.dragRectangle);
            this.layoutHelp.dragPane.getChildren().remove((Object)this.startTimeText);
            this.layoutHelp.dragPane.getChildren().remove((Object)this.endTimeText);
            this.dragRectangle = null;
            this.startTimeText = null;
            this.endTimeText = null;
            this.appointmentForDrag = null;
        }
        if (!this.mouseActuallyHasDragged) {
            this.handleSelect(mouseEvent);
            return;
        }
        LocalDateTime dragDropDateTime = this.layoutHelp.skin.convertClickInSceneToDateTime(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        if (dragDropDateTime != null) {
            this.handleDrag(this.appointment, this.dragPickupDateTime, dragDropDateTime);
            this.layoutHelp.skin.setupAppointments();
        }
    }

    private /* synthetic */ void lambda$setupDragging$9(MouseEvent mouseEvent) {
        if (!this.dragging) {
            return;
        }
        mouseEvent.consume();
        if (this.dragRectangle == null) {
            this.setCursor(Cursor.MOVE);
            this.dragRectangle = new Rectangle(0.0, 0.0, NodeUtil.snapWH((double)0.0, (double)this.getWidth()), NodeUtil.snapWH((double)0.0, (double)(this.appointment.isWholeDay() != false ? this.layoutHelp.titleDateTimeHeightProperty.get() : this.getHeight())));
            this.dragRectangle.getStyleClass().add((Object)"GhostRectangle");
            this.layoutHelp.dragPane.getChildren().add((Object)this.dragRectangle);
            this.startTimeText = new Text("...");
            this.startTimeText.getStyleClass().add((Object)"GhostRectangleText");
            if (this.showStartTimeText()) {
                this.layoutHelp.dragPane.getChildren().add((Object)this.startTimeText);
            }
            this.endTimeText = new Text("...");
            this.endTimeText.getStyleClass().add((Object)"GhostRectangleText");
            if (this.showEndTimeText()) {
                this.layoutHelp.dragPane.getChildren().add((Object)this.endTimeText);
            }
            this.appointmentForDrag = new AppointmentForDrag();
        }
        double lX = NodeUtil.xInParent((Node)this, (Node)this.layoutHelp.dragPane) + (mouseEvent.getX() - this.startX);
        double lY = NodeUtil.yInParent((Node)this, (Node)this.layoutHelp.dragPane) + (mouseEvent.getY() - this.startY);
        this.dragRectangle.setX(NodeUtil.snapXY((double)lX));
        this.dragRectangle.setY(NodeUtil.snapXY((double)lY));
        this.startTimeText.layoutXProperty().set(this.dragRectangle.getX());
        this.startTimeText.layoutYProperty().set(this.dragRectangle.getY());
        this.endTimeText.layoutXProperty().set(this.dragRectangle.getX());
        this.endTimeText.layoutYProperty().set(this.dragRectangle.getY() + this.dragRectangle.getHeight() + this.endTimeText.getBoundsInParent().getHeight());
        this.mouseActuallyHasDragged = true;
        this.appointmentForDrag.setStartLocalDateTime(this.appointment.getStartLocalDateTime());
        this.appointmentForDrag.setEndLocalDateTime(this.appointment.getEndLocalDateTime());
        this.appointmentForDrag.setWholeDay(this.appointment.isWholeDay());
        LocalDateTime dragCurrentDateTime = this.layoutHelp.skin.convertClickInSceneToDateTime(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        if (dragCurrentDateTime != null) {
            this.handleDrag(this.appointmentForDrag, this.dragPickupDateTime, dragCurrentDateTime);
            this.startTimeText.setText(this.appointmentForDrag.isWholeDay() != false ? "" : this.layoutHelp.timeDateTimeFormatter.format(this.appointmentForDrag.getStartLocalDateTime()));
            this.endTimeText.setText(this.appointmentForDrag.isWholeDay() != false || this.appointmentForDrag.getEndLocalDateTime() == null ? "" : this.layoutHelp.timeDateTimeFormatter.format(this.appointmentForDrag.getEndLocalDateTime()));
        }
    }

    private /* synthetic */ void lambda$setupDragging$8(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.handleAction();
            return;
        }
        if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
            this.appointmentMenu.showMenu(mouseEvent);
            return;
        }
        if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            return;
        }
        mouseEvent.consume();
        if (mouseEvent.getClickCount() > 1) {
            this.handleAction();
            return;
        }
        if (!this.layoutHelp.skinnable.getAllowDragging()) {
            this.handleSelect(mouseEvent);
            return;
        }
        this.startX = mouseEvent.getX();
        this.startY = mouseEvent.getY();
        this.dragPickupDateTime = this.layoutHelp.skin.convertClickInSceneToDateTime(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        this.mouseActuallyHasDragged = false;
        this.dragging = true;
    }

    static /* synthetic */ void access$lambda$0(AppointmentAbstractPane appointmentAbstractPane, MouseEvent mouseEvent) {
        appointmentAbstractPane.lambda$setupDragging$8(mouseEvent);
    }

    static /* synthetic */ void access$lambda$1(AppointmentAbstractPane appointmentAbstractPane, MouseEvent mouseEvent) {
        appointmentAbstractPane.lambda$setupDragging$9(mouseEvent);
    }

    static /* synthetic */ void access$lambda$2(AppointmentAbstractPane appointmentAbstractPane, MouseEvent mouseEvent) {
        appointmentAbstractPane.lambda$setupDragging$10(mouseEvent);
    }

    public static class AppointmentForDrag
    extends Agenda.AppointmentImplLocal {
        @Override
        public void setEndTemporal(Temporal temporal) {
            Agenda$Appointment$.setEndTemporal(this, temporal);
        }

        @Override
        public void setStartTime(Calendar calendar) {
            Agenda$Appointment$.setStartTime(this, calendar);
        }

        @Override
        public void setEndTime(Calendar calendar) {
            Agenda$Appointment$.setEndTime(this, calendar);
        }

        @Override
        public Calendar getStartTime() {
            return Agenda$Appointment$.getStartTime(this);
        }

        @Override
        public Temporal getEndTemporal() {
            return Agenda$Appointment$.getEndTemporal(this);
        }

        @Override
        public Calendar getEndTime() {
            return Agenda$Appointment$.getEndTime(this);
        }

        @Override
        public Temporal getStartTemporal() {
            return Agenda$Appointment$.getStartTemporal(this);
        }

        @Override
        public void setStartTemporal(Temporal temporal) {
            Agenda$Appointment$.setStartTemporal(this, temporal);
        }
    }
}

