/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDateTime;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.stage.Popup;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$1;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$10;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$11;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$12;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$13;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$2;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$3;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$4;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$5;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$6;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$7;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$8;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu$$Lambda$9;
import jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import jfxtras.scene.control.ImageViewButton;
import jfxtras.scene.control.LocalDateTimeTextField;
import jfxtras.scene.control.agenda.Agenda;
import jfxtras.util.NodeUtil;

class AppointmentMenu
extends Rectangle {
    final Pane pane;
    final Agenda.Appointment appointment;
    final LayoutHelp layoutHelp;
    private Popup popup;
    private ImageViewButton closeIconImageView = null;
    private LocalDateTimeTextField startTextField = null;
    private LocalDateTimeTextField endTextField = null;
    private CheckBox wholedayCheckBox = null;
    private TextField summaryTextField = null;
    private TextField locationTextField = null;
    private ImageViewButton deleteImageViewButton = null;
    private ImageViewButton actionImageViewButton = null;

    AppointmentMenu(Pane pane, Agenda.Appointment appointment, LayoutHelp layoutHelp) {
        this.pane = pane;
        this.appointment = appointment;
        this.layoutHelp = layoutHelp;
        this.setX(NodeUtil.snapXY((double)layoutHelp.paddingProperty.get()));
        this.setY(NodeUtil.snapXY((double)layoutHelp.paddingProperty.get()));
        this.setWidth(6.0);
        this.setHeight(3.0);
        this.getStyleClass().add((Object)"MenuIcon");
        layoutHelp.setupMouseOverAsBusy((Node)this);
        this.setupMouseClick();
    }

    private void setupMouseClick() {
        this.setOnMousePressed(AppointmentMenu$$Lambda$1.lambdaFactory$());
        this.setOnMouseReleased(AppointmentMenu$$Lambda$2.lambdaFactory$());
        this.setOnMouseClicked(AppointmentMenu$$Lambda$3.lambdaFactory$(this));
    }

    void showMenu(MouseEvent mouseEvent) {
        Callback<Agenda.Appointment, Void> lEditCallback = this.layoutHelp.skinnable.getEditAppointmentCallback();
        if (lEditCallback != null) {
            lEditCallback.call((Object)this.appointment);
            return;
        }
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        this.popup = new Popup();
        this.popup.setAutoFix(true);
        this.popup.setAutoHide(true);
        this.popup.setHideOnEscape(true);
        this.popup.setOnHidden(AppointmentMenu$$Lambda$4.lambdaFactory$(this));
        BorderPane lBorderPane = new BorderPane(){

            public String getUserAgentStylesheet() {
                return AppointmentMenu.this.layoutHelp.skinnable.getUserAgentStylesheet();
            }
        };
        lBorderPane.getStyleClass().add((Object)(((Object)((Object)this.layoutHelp.skinnable)).getClass().getSimpleName() + "Popup"));
        this.popup.getContent().add((Object)lBorderPane);
        lBorderPane.setRight((Node)this.createCloseIcon());
        VBox lVBox = new VBox(this.layoutHelp.paddingProperty.get());
        lBorderPane.setCenter((Node)lVBox);
        lVBox.getChildren().add((Object)new Text("Time:"));
        lVBox.getChildren().add((Object)this.createStartTextField());
        lVBox.getChildren().add((Object)this.createEndTextField());
        if (this.appointment.isWholeDay() != null && this.appointment.isWholeDay().booleanValue() || this.appointment.getEndLocalDateTime() != null) {
            lVBox.getChildren().add((Object)this.createWholedayCheckbox());
        }
        lVBox.getChildren().add((Object)new Text("Summary:"));
        lVBox.getChildren().add((Object)this.createSummaryTextField());
        lVBox.getChildren().add((Object)new Text("Location:"));
        lVBox.getChildren().add((Object)this.createLocationTextField());
        lVBox.getChildren().add((Object)new Text("Actions:"));
        lVBox.getChildren().add((Object)this.createActions());
        lVBox.getChildren().add((Object)new Text("Group:"));
        lVBox.getChildren().add((Object)this.createAppointmentGroups());
        this.popup.show((Node)this.pane, NodeUtil.screenX((Node)this.pane), NodeUtil.screenY((Node)this.pane));
    }

    private ImageViewButton createCloseIcon() {
        this.closeIconImageView = new ImageViewButton();
        this.closeIconImageView.getStyleClass().add((Object)"close-icon");
        this.closeIconImageView.setPickOnBounds(true);
        this.closeIconImageView.setOnMouseClicked(AppointmentMenu$$Lambda$5.lambdaFactory$(this));
        return this.closeIconImageView;
    }

    private LocalDateTimeTextField createStartTextField() {
        this.startTextField = new LocalDateTimeTextField();
        this.startTextField.setLocale(this.layoutHelp.skinnable.getLocale());
        this.startTextField.setLocalDateTime(this.appointment.getStartLocalDateTime());
        this.startTextField.localDateTimeProperty().addListener(AppointmentMenu$$Lambda$6.lambdaFactory$(this));
        return this.startTextField;
    }

    private LocalDateTimeTextField createEndTextField() {
        this.endTextField = new LocalDateTimeTextField();
        this.endTextField.setLocale(this.layoutHelp.skinnable.getLocale());
        this.endTextField.setLocalDateTime(this.appointment.getEndLocalDateTime());
        this.endTextField.setVisible(this.appointment.getEndLocalDateTime() != null);
        this.endTextField.localDateTimeProperty().addListener(AppointmentMenu$$Lambda$7.lambdaFactory$(this));
        return this.endTextField;
    }

    private CheckBox createWholedayCheckbox() {
        this.wholedayCheckBox = new CheckBox("Wholeday");
        this.wholedayCheckBox.setId("wholeday-checkbox");
        this.wholedayCheckBox.selectedProperty().set(this.appointment.isWholeDay().booleanValue());
        this.wholedayCheckBox.selectedProperty().addListener(AppointmentMenu$$Lambda$8.lambdaFactory$(this));
        return this.wholedayCheckBox;
    }

    private TextField createSummaryTextField() {
        this.summaryTextField = new TextField();
        this.summaryTextField.setText(this.appointment.getSummary());
        this.summaryTextField.textProperty().addListener(AppointmentMenu$$Lambda$9.lambdaFactory$(this));
        return this.summaryTextField;
    }

    private TextField createLocationTextField() {
        this.locationTextField = new TextField();
        this.locationTextField.setText(this.appointment.getLocation() == null ? "" : this.appointment.getLocation());
        this.locationTextField.textProperty().addListener(AppointmentMenu$$Lambda$10.lambdaFactory$(this));
        return this.locationTextField;
    }

    private HBox createActions() {
        HBox lHBox = new HBox();
        this.deleteImageViewButton = this.createActionButton("delete-icon", "Delete");
        this.deleteImageViewButton.setOnMouseClicked(AppointmentMenu$$Lambda$11.lambdaFactory$(this));
        lHBox.getChildren().add((Object)this.deleteImageViewButton);
        if (this.layoutHelp.skinnable.getActionCallback() != null) {
            this.actionImageViewButton = this.createActionButton("action-icon", "Action");
            this.actionImageViewButton.setOnMouseClicked(AppointmentMenu$$Lambda$12.lambdaFactory$(this));
            lHBox.getChildren().add((Object)this.actionImageViewButton);
        }
        return lHBox;
    }

    private ImageViewButton createActionButton(String styleClass, String tooltipText) {
        ImageViewButton lImageViewButton = new ImageViewButton();
        lImageViewButton.getStyleClass().add((Object)styleClass);
        lImageViewButton.setPickOnBounds(true);
        Tooltip.install((Node)lImageViewButton, (Tooltip)new Tooltip(tooltipText));
        return lImageViewButton;
    }

    private GridPane createAppointmentGroups() {
        GridPane lAppointmentGroupGridPane = new GridPane();
        lAppointmentGroupGridPane.getStyleClass().add((Object)"AppointmentGroups");
        lAppointmentGroupGridPane.setHgap(2.0);
        lAppointmentGroupGridPane.setVgap(2.0);
        int lCnt = 0;
        for (Agenda.AppointmentGroup lAppointmentGroup : this.layoutHelp.skinnable.appointmentGroups()) {
            Pane lPane = new Pane();
            lPane.setPrefSize(15.0, 15.0);
            lPane.getStyleClass().addAll((Object[])new String[]{"AppointmentGroup", lAppointmentGroup.getStyleClass()});
            lAppointmentGroupGridPane.add((Node)lPane, lCnt % 10, lCnt / 10);
            ++lCnt;
            if (lAppointmentGroup.getDescription() != null) {
                Tooltip.install((Node)lPane, (Tooltip)new Tooltip(lAppointmentGroup.getDescription()));
            }
            this.layoutHelp.setupMouseOverAsBusy((Node)lPane);
            lPane.setOnMouseClicked(AppointmentMenu$$Lambda$13.lambdaFactory$(this, lAppointmentGroup));
        }
        return lAppointmentGroupGridPane;
    }

    private /* synthetic */ void lambda$createAppointmentGroups$35(Agenda.AppointmentGroup appointmentGroup, MouseEvent mouseEvent) {
        mouseEvent.consume();
        this.appointment.setAppointmentGroup(appointmentGroup);
        this.layoutHelp.callAppointmentChangedCallback(this.appointment);
        this.popup.hide();
    }

    private /* synthetic */ void lambda$createActions$34(MouseEvent mouseEvent) {
        this.popup.hide();
        this.layoutHelp.skinnable.getActionCallback().call((Object)this.appointment);
    }

    private /* synthetic */ void lambda$createActions$33(MouseEvent mouseEvent) {
        this.popup.hide();
        this.layoutHelp.skinnable.appointments().remove((Object)this.appointment);
    }

    private /* synthetic */ void lambda$createLocationTextField$32(ObservableValue observable, String oldValue, String newValue) {
        this.appointment.setLocation(newValue);
        this.layoutHelp.callAppointmentChangedCallback(this.appointment);
    }

    private /* synthetic */ void lambda$createSummaryTextField$31(ObservableValue observable, String oldValue, String newValue) {
        this.appointment.setSummary(newValue);
        this.layoutHelp.callAppointmentChangedCallback(this.appointment);
    }

    private /* synthetic */ void lambda$createWholedayCheckbox$30(ObservableValue observable, Boolean oldValue, Boolean newValue) {
        this.appointment.setWholeDay(newValue);
        if (newValue.booleanValue()) {
            this.appointment.setEndLocalDateTime(null);
        } else {
            LocalDateTime lEndTime = this.appointment.getStartLocalDateTime().plusMinutes(30L);
            this.appointment.setEndLocalDateTime(lEndTime);
            this.endTextField.setLocalDateTime(this.appointment.getEndLocalDateTime());
        }
        this.endTextField.setVisible(this.appointment.getEndLocalDateTime() != null);
        this.layoutHelp.callAppointmentChangedCallback(this.appointment);
    }

    private /* synthetic */ void lambda$createEndTextField$29(ObservableValue observable, LocalDateTime oldValue, LocalDateTime newValue) {
        this.appointment.setEndLocalDateTime(newValue);
        this.layoutHelp.callAppointmentChangedCallback(this.appointment);
    }

    private /* synthetic */ void lambda$createStartTextField$28(ObservableValue observable, LocalDateTime oldValue, LocalDateTime newValue) {
        LocalDateTime lOldStart = this.appointment.getStartLocalDateTime();
        this.appointment.setStartLocalDateTime(newValue);
        if (this.appointment.getEndLocalDateTime() != null) {
            long lDurationInNano = this.appointment.getEndLocalDateTime().getNano() - lOldStart.getNano();
            LocalDateTime lEndLocalDateTime = this.appointment.getStartLocalDateTime().plusNanos(lDurationInNano);
            this.appointment.setEndLocalDateTime(lEndLocalDateTime);
            this.endTextField.setLocalDateTime(this.appointment.getEndLocalDateTime());
        }
        this.layoutHelp.callAppointmentChangedCallback(this.appointment);
    }

    private /* synthetic */ void lambda$createCloseIcon$27(MouseEvent mouseEvent2) {
        this.popup.hide();
    }

    private /* synthetic */ void lambda$showMenu$26(WindowEvent windowEvent) {
        this.layoutHelp.skin.setupAppointments();
    }

    private /* synthetic */ void lambda$setupMouseClick$25(MouseEvent mouseEvent) {
        mouseEvent.consume();
        this.showMenu(mouseEvent);
    }

    static /* synthetic */ void access$lambda$0(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    static /* synthetic */ void access$lambda$1(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    static /* synthetic */ void access$lambda$2(AppointmentMenu appointmentMenu, MouseEvent mouseEvent) {
        appointmentMenu.lambda$setupMouseClick$25(mouseEvent);
    }

    static /* synthetic */ void access$lambda$3(AppointmentMenu appointmentMenu, WindowEvent windowEvent) {
        appointmentMenu.lambda$showMenu$26(windowEvent);
    }

    static /* synthetic */ void access$lambda$4(AppointmentMenu appointmentMenu, MouseEvent mouseEvent) {
        appointmentMenu.lambda$createCloseIcon$27(mouseEvent);
    }

    static /* synthetic */ void access$lambda$5(AppointmentMenu appointmentMenu, ObservableValue observableValue, LocalDateTime localDateTime, LocalDateTime localDateTime2) {
        appointmentMenu.lambda$createStartTextField$28(observableValue, localDateTime, localDateTime2);
    }

    static /* synthetic */ void access$lambda$6(AppointmentMenu appointmentMenu, ObservableValue observableValue, LocalDateTime localDateTime, LocalDateTime localDateTime2) {
        appointmentMenu.lambda$createEndTextField$29(observableValue, localDateTime, localDateTime2);
    }

    static /* synthetic */ void access$lambda$7(AppointmentMenu appointmentMenu, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        appointmentMenu.lambda$createWholedayCheckbox$30(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$8(AppointmentMenu appointmentMenu, ObservableValue observableValue, String string, String string2) {
        appointmentMenu.lambda$createSummaryTextField$31(observableValue, string, string2);
    }

    static /* synthetic */ void access$lambda$9(AppointmentMenu appointmentMenu, ObservableValue observableValue, String string, String string2) {
        appointmentMenu.lambda$createLocationTextField$32(observableValue, string, string2);
    }

    static /* synthetic */ void access$lambda$10(AppointmentMenu appointmentMenu, MouseEvent mouseEvent) {
        appointmentMenu.lambda$createActions$33(mouseEvent);
    }

    static /* synthetic */ void access$lambda$11(AppointmentMenu appointmentMenu, MouseEvent mouseEvent) {
        appointmentMenu.lambda$createActions$34(mouseEvent);
    }

    static /* synthetic */ void access$lambda$12(AppointmentMenu appointmentMenu, Agenda.AppointmentGroup appointmentGroup, MouseEvent mouseEvent) {
        appointmentMenu.lambda$createAppointmentGroups$35(appointmentGroup, mouseEvent);
    }
}

