/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDateTime;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AgendaSkinTimeScale24HourAbstract;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentRegularBodyPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.DurationDragger$$Lambda$1;
import jfxtras.internal.scene.control.skin.agenda.base24hour.DurationDragger$$Lambda$2;
import jfxtras.internal.scene.control.skin.agenda.base24hour.DurationDragger$$Lambda$3;
import jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import jfxtras.scene.control.agenda.Agenda;
import jfxtras.util.NodeUtil;

class DurationDragger
extends Rectangle {
    private final AppointmentRegularBodyPane appointmentPane;
    private final Agenda.Appointment appointment;
    private final LayoutHelp layoutHelp;
    private double minimumHeight = 5.0;
    private Rectangle resizeRectangle = null;
    private Text endTimeText = null;

    DurationDragger(AppointmentRegularBodyPane appointmentPane, Agenda.Appointment appointment, LayoutHelp layoutHelp) {
        this.appointmentPane = appointmentPane;
        this.appointment = appointment;
        this.layoutHelp = layoutHelp;
        this.xProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)appointmentPane.widthProperty().multiply(0.25)));
        this.yProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)appointmentPane.heightProperty().subtract(5)));
        this.widthProperty().bind((ObservableValue)appointmentPane.widthProperty().multiply(0.5));
        this.setHeight(3.0);
        this.minimumHeight = ((AgendaSkinTimeScale24HourAbstract)layoutHelp.skin).getSnapToMinutes() * 60.0 * 1000.0 / layoutHelp.durationInMSPerPixelProperty.get();
        this.getStyleClass().add((Object)"DurationDragger");
        layoutHelp.setupMouseOverAsBusy((Node)this);
        this.setupMouseDrag();
    }

    private void setupMouseDrag() {
        this.setOnMousePressed(DurationDragger$$Lambda$1.lambdaFactory$(this));
        this.setOnMouseDragged(DurationDragger$$Lambda$2.lambdaFactory$(this));
        this.setOnMouseReleased(DurationDragger$$Lambda$3.lambdaFactory$(this));
    }

    private LocalDateTime calculateEndDateTime() {
        int ms = (int)(this.resizeRectangle.getHeight() * this.layoutHelp.durationInMSPerPixelProperty.get());
        LocalDateTime endLocalDateTime = this.appointmentPane.startDateTime.plusSeconds(ms / 1000);
        endLocalDateTime = this.layoutHelp.roundTimeToNearestMinutes(endLocalDateTime, (int)((AgendaSkinTimeScale24HourAbstract)this.layoutHelp.skin).getSnapToMinutes());
        return endLocalDateTime;
    }

    private /* synthetic */ void lambda$setupMouseDrag$38(MouseEvent mouseEvent) {
        if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            return;
        }
        LocalDateTime endLocalDateTime = this.calculateEndDateTime();
        mouseEvent.consume();
        this.setCursor(Cursor.HAND);
        ((Pane)this.appointmentPane.getParent()).getChildren().remove((Object)this.resizeRectangle);
        this.resizeRectangle = null;
        ((Pane)this.appointmentPane.getParent()).getChildren().remove((Object)this.endTimeText);
        this.endTimeText = null;
        this.appointmentPane.appointment.setEndLocalDateTime(endLocalDateTime);
        this.layoutHelp.callAppointmentChangedCallback(this.appointment);
        this.layoutHelp.skin.setupAppointments();
    }

    private /* synthetic */ void lambda$setupMouseDrag$37(MouseEvent mouseEvent) {
        if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            return;
        }
        mouseEvent.consume();
        double lNodeScreenY = NodeUtil.screenY((Node)this.appointmentPane);
        double lMouseY = mouseEvent.getScreenY();
        double lHeight = lMouseY - lNodeScreenY;
        if (lHeight < this.minimumHeight) {
            lHeight = this.minimumHeight;
        }
        this.resizeRectangle.setHeight(NodeUtil.snapWH((double)this.resizeRectangle.getLayoutY(), (double)lHeight));
        LocalDateTime endLocalDateTime = this.calculateEndDateTime();
        this.endTimeText.setText(this.layoutHelp.timeDateTimeFormatter.format(endLocalDateTime));
    }

    private /* synthetic */ void lambda$setupMouseDrag$36(MouseEvent mouseEvent) {
        if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            return;
        }
        mouseEvent.consume();
        this.setCursor(Cursor.V_RESIZE);
        this.resizeRectangle = new Rectangle(this.appointmentPane.getLayoutX(), this.appointmentPane.getLayoutY(), this.appointmentPane.getWidth(), this.appointmentPane.getHeight());
        this.resizeRectangle.getStyleClass().add((Object)"GhostRectangle");
        ((Pane)this.appointmentPane.getParent()).getChildren().add((Object)this.resizeRectangle);
        this.endTimeText = new Text(this.layoutHelp.timeDateTimeFormatter.format(this.appointment.getEndLocalDateTime()));
        this.endTimeText.layoutXProperty().set(this.appointmentPane.getLayoutX());
        this.endTimeText.layoutYProperty().bind((ObservableValue)this.resizeRectangle.heightProperty().add(this.appointmentPane.getLayoutY()));
        this.endTimeText.getStyleClass().add((Object)"GhostRectangleText");
        ((Pane)this.appointmentPane.getParent()).getChildren().add((Object)this.endTimeText);
    }

    static /* synthetic */ void access$lambda$0(DurationDragger durationDragger, MouseEvent mouseEvent) {
        durationDragger.lambda$setupMouseDrag$36(mouseEvent);
    }

    static /* synthetic */ void access$lambda$1(DurationDragger durationDragger, MouseEvent mouseEvent) {
        durationDragger.lambda$setupMouseDrag$37(mouseEvent);
    }

    static /* synthetic */ void access$lambda$2(DurationDragger durationDragger, MouseEvent mouseEvent) {
        durationDragger.lambda$setupMouseDrag$38(mouseEvent);
    }
}

