/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.layout.responsivepane;

import jfxtras.scene.layout.responsivepane.ResponsivePane;
import jfxtras.scene.layout.responsivepane.Size;
import jfxtras.scene.layout.responsivepane.Unit;

public class Diagonal
extends Size {
    final Unit unit;
    final double value;

    Diagonal(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    double toInches(ResponsivePane responsivePane) {
        return this.unit.toInches(this.value);
    }

    public static Diagonal inch(double v) {
        return new Diagonal(v, Unit.INCH);
    }

    public static Diagonal cm(double v) {
        return new Diagonal(v, Unit.CM);
    }

    public static Diagonal valueOf(String s) {
        if ((s = s.trim()).endsWith(Unit.INCH.suffix)) {
            return Diagonal.inch(Double.parseDouble(s.substring(0, s.length() - Unit.INCH.suffix.length())));
        }
        if (s.endsWith(Unit.CM.suffix)) {
            return Diagonal.cm(Double.parseDouble(s.substring(0, s.length() - Unit.CM.suffix.length())));
        }
        throw new IllegalArgumentException("Don't know how to parse '" + s + "'");
    }

    public String toString() {
        return this.value + this.unit.suffix;
    }
}

