/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.LocalDateTextFieldSkin;
import jfxtras.internal.scene.control.skin.TextFieldSkin;
import jfxtras.scene.control.LocalDatePicker;

public class LocalDateTextField
extends Control {
    private final ObjectProperty<LocalDate> localDateObjectProperty = new SimpleObjectProperty((Object)this, "localDate");
    private final ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty<Locale>(Locale.getDefault()){

        public void set(Locale value) {
            super.set((Object)value);
            if (!LocalDateTextField.this.dateFormatManual) {
                LocalDateTextField.this.setDateTimeFormatter(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).withLocale(LocalDateTextField.this.getLocale()));
            }
        }
    };
    private final ObjectProperty<DateTimeFormatter> dateTimeFormatterObjectProperty = new SimpleObjectProperty<DateTimeFormatter>((Object)this, "dateTimeFormatter", DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(this.getLocale())){

        public void set(DateTimeFormatter value) {
            super.set((Object)(value != null ? value : DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(LocalDateTextField.this.getLocale())));
            LocalDateTextField.this.dateFormatManual = value != null;
        }
    };
    private boolean dateFormatManual = false;
    ListProperty<DateTimeFormatter> dateTimeFormattersProperty = new SimpleListProperty(FXCollections.observableList(new ArrayList()));
    private final ObjectProperty<String> promptTextObjectProperty = new SimpleObjectProperty((Object)this, "promptText", null);
    private final ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackObjectProperty = new SimpleObjectProperty((Object)this, "parseErrorCallback", null);
    private final ObservableList<LocalDate> highlightedLocalDates = FXCollections.observableArrayList();
    private final ObservableList<LocalDate> disabledLocalDates = FXCollections.observableArrayList();
    private final ObjectProperty<Callback<LocalDatePicker.LocalDateRange, Void>> localDateRangeCallbackObjectProperty = new SimpleObjectProperty((Object)this, "localDateRangeCallback", null);
    private final ObjectProperty<Callback<LocalDate, Boolean>> valueValidationCallbackObjectProperty = new SimpleObjectProperty((Object)this, "valueValidationCallback", null);
    private volatile ObjectProperty<LocalDate> displayedLocalDateObjectProperty = new SimpleObjectProperty((Object)this, "displayedLocalDate");
    private volatile BooleanProperty allowNullProperty = new SimpleBooleanProperty((Object)this, "allowNull", true);
    private final ObjectProperty<String> textObjectProperty = new SimpleObjectProperty((Object)this, "text", null);
    private final BooleanProperty pickerShowingProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty editableProperty = new SimpleBooleanProperty(true);

    public LocalDateTextField() {
        this.construct();
    }

    public LocalDateTextField(LocalDate localDate) {
        this.construct();
        this.setLocalDate(localDate);
    }

    private void construct() {
        this.constructDisplayedLocalDate();
    }

    public Skin createDefaultSkin() {
        return new LocalDateTextFieldSkin(this);
    }

    public void selectAll() {
        if (this.getSkin() != null && this.getSkin() instanceof TextFieldSkin) {
            ((TextFieldSkin)this.getSkin()).selectAll();
        }
    }

    public ObjectProperty<LocalDate> localDateProperty() {
        return this.localDateObjectProperty;
    }

    public LocalDate getLocalDate() {
        return (LocalDate)this.localDateObjectProperty.getValue();
    }

    public void setLocalDate(LocalDate value) {
        this.localDateObjectProperty.setValue((Object)value);
    }

    public LocalDateTextField withLocalDate(LocalDate value) {
        this.setLocalDate(value);
        return this;
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public LocalDateTextField withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty() {
        return this.dateTimeFormatterObjectProperty;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.dateTimeFormatterObjectProperty.getValue();
    }

    public void setDateTimeFormatter(DateTimeFormatter value) {
        this.dateTimeFormatterObjectProperty.setValue((Object)value);
    }

    public LocalDateTextField withDateTimeFormatter(DateTimeFormatter value) {
        this.setDateTimeFormatter(value);
        return this;
    }

    public ListProperty<DateTimeFormatter> dateTimeFormattersProperty() {
        return this.dateTimeFormattersProperty;
    }

    public ObservableList<DateTimeFormatter> getDateTimeFormatters() {
        return this.dateTimeFormattersProperty.getValue();
    }

    public void setDateTimeFormatters(ObservableList<DateTimeFormatter> value) {
        this.dateTimeFormattersProperty.setValue(value);
    }

    public LocalDateTextField withDateTimeFormatter(ObservableList<DateTimeFormatter> value) {
        this.setDateTimeFormatters(value);
        return this;
    }

    public ObjectProperty<String> promptTextProperty() {
        return this.promptTextObjectProperty;
    }

    public String getPromptText() {
        return (String)this.promptTextObjectProperty.get();
    }

    public void setPromptText(String value) {
        this.promptTextObjectProperty.set((Object)value);
    }

    public LocalDateTextField withPromptText(String value) {
        this.setPromptText(value);
        return this;
    }

    public ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackProperty() {
        return this.parseErrorCallbackObjectProperty;
    }

    public Callback<Throwable, Void> getParseErrorCallback() {
        return (Callback)this.parseErrorCallbackObjectProperty.getValue();
    }

    public void setParseErrorCallback(Callback<Throwable, Void> value) {
        this.parseErrorCallbackObjectProperty.setValue(value);
    }

    public LocalDateTextField withParseErrorCallback(Callback<Throwable, Void> value) {
        this.setParseErrorCallback(value);
        return this;
    }

    public ObservableList<LocalDate> highlightedLocalDates() {
        return this.highlightedLocalDates;
    }

    public ObservableList<LocalDate> disabledLocalDates() {
        return this.disabledLocalDates;
    }

    public ObjectProperty<Callback<LocalDatePicker.LocalDateRange, Void>> LocalDateRangeCallbackProperty() {
        return this.localDateRangeCallbackObjectProperty;
    }

    public Callback<LocalDatePicker.LocalDateRange, Void> getLocalDateRangeCallback() {
        return (Callback)this.localDateRangeCallbackObjectProperty.getValue();
    }

    public void setLocalDateRangeCallback(Callback<LocalDatePicker.LocalDateRange, Void> value) {
        this.localDateRangeCallbackObjectProperty.setValue(value);
    }

    public LocalDateTextField withLocalDateRangeCallback(Callback<LocalDatePicker.LocalDateRange, Void> value) {
        this.setLocalDateRangeCallback(value);
        return this;
    }

    public ObjectProperty<Callback<LocalDate, Boolean>> valueValidationCallbackProperty() {
        return this.valueValidationCallbackObjectProperty;
    }

    public Callback<LocalDate, Boolean> getValueValidationCallback() {
        return (Callback)this.valueValidationCallbackObjectProperty.getValue();
    }

    public void setValueValidationCallback(Callback<LocalDate, Boolean> value) {
        this.valueValidationCallbackObjectProperty.setValue(value);
    }

    public LocalDateTextField withValueValidationCallback(Callback<LocalDate, Boolean> value) {
        this.setValueValidationCallback(value);
        return this;
    }

    public ObjectProperty<LocalDate> displayedLocalDate() {
        return this.displayedLocalDateObjectProperty;
    }

    public LocalDate getDisplayedLocalDate() {
        return (LocalDate)this.displayedLocalDateObjectProperty.getValue();
    }

    public void setDisplayedLocalDate(LocalDate value) {
        this.displayedLocalDateObjectProperty.setValue((Object)value);
    }

    public LocalDateTextField withDisplayedLocalDate(LocalDate value) {
        this.setDisplayedLocalDate(value);
        return this;
    }

    private void constructDisplayedLocalDate() {
        this.setDisplayedLocalDate(LocalDate.now());
    }

    public BooleanProperty allowNullProperty() {
        return this.allowNullProperty;
    }

    public boolean getAllowNull() {
        return this.allowNullProperty.get();
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNullProperty.set(allowNull);
    }

    public LocalDateTextField withAllowNull(boolean value) {
        this.setAllowNull(value);
        return this;
    }

    public ObjectProperty<String> textProperty() {
        return this.textObjectProperty;
    }

    public String getText() {
        return (String)this.textObjectProperty.get();
    }

    public void setText(String value) {
        this.textObjectProperty.set((Object)value);
    }

    public LocalDateTextField withText(String value) {
        this.setText(value);
        return this;
    }

    public BooleanProperty pickerShowingProperty() {
        return this.pickerShowingProperty;
    }

    public boolean isPickerShowing() {
        return this.pickerShowingProperty.get();
    }

    public void setPickerShowing(boolean value) {
        this.pickerShowingProperty.set(value);
    }

    public LocalDateTextField withPickerShowing(boolean value) {
        this.setPickerShowing(value);
        return this;
    }

    public BooleanProperty editableProperty() {
        return this.editableProperty;
    }

    public boolean isEditable() {
        return this.editableProperty.get();
    }

    public void setEditable(boolean value) {
        this.editableProperty.set(value);
    }

    public LocalDateTextField withEditable(boolean value) {
        this.setEditable(value);
        return this;
    }
}

